/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const RICH_TEXT_MIGRATION_XSL_CONTENT =
"<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns=\"http://docbook.org/ns/docbook\" xmlns:docbook=\"http://docbook.org/ns/docbook\">" + 
    "<xsl:template match=\"docbook:para[@class='blue']\">" +
        "<docbook:para class=\"important\">" +
            "<xsl:copy-of select=\"@*[name() != 'class']\"/>" +
            "<xsl:apply-templates/>" +
        "</docbook:para>" +
    "</xsl:template>" +
    "<xsl:template match=\"docbook:para[@class='red']\">" +
        "<docbook:para class=\"important-strong\">" +
            "<xsl:copy-of select=\"@*[name() != 'class']\"/>" +
            "<xsl:apply-templates/>" +
        "</docbook:para>" +
    "</xsl:template>" +
    "<xsl:template match=\"docbook:para[@class='grey']\">" +
        "<docbook:para class=\"secondary\">" +
            "<xsl:copy-of select=\"@*[name() != 'class']\"/>" +
            "<xsl:apply-templates/>" +
        "</docbook:para>" +
    "</xsl:template>" +
    "<xsl:template match=\"docbook:table[@class='blue-table']\">" +
        "<docbook:table class=\"data\">" +
            "<xsl:copy-of select=\"@*[name() != 'class']\"/>" +
            "<xsl:apply-templates/>" +
        "</docbook:table>" +
    "</xsl:template>" +
    "<xsl:template match=\"docbook:table[@class='red-table']\">" +
        "<docbook:table class=\"datastrong\">" +
            "<xsl:copy-of select=\"@*[name() != 'class']\"/>" +
            "<xsl:apply-templates/>" +
        "</docbook:table>" +
    "</xsl:template>" +
    "<xsl:template match=\"*\">" + 
        "<xsl:copy>" +
            "<xsl:copy-of select=\"@*\"/>" +
            "<xsl:apply-templates/>" +
        "</xsl:copy>" +
    "</xsl:template>" +
"</xsl:stylesheet>";

const IOUtils = Java.type('org.apache.commons.io.IOUtils');
const skinManager = Ametys.serviceManager.lookup(org.ametys.web.skin.SkinsManager.ROLE);

// Get sites with intranet-cards skins
let siteNames = [];
Repository.query("//element(*, ametys:site)").forEach(function(site) {
    let skinId = site.getSkinId()
    if (skinId == 'intranet-cards' || skinManager.getSkin(skinId).getParents().contains("intranet-cards"))
    {
        siteNames.push(site.getName());
    }
});
logger.info(`Found ${siteNames.length} site with docbook to migrate`);
  
let handledVersions=0;
  
let saxFactory = javax.xml.transform.TransformerFactory.newInstance();
let reader = null;
let templates = null;
try
{
    /* Prepare XSL once */; 
    reader = new java.io.StringReader(RICH_TEXT_MIGRATION_XSL_CONTENT);
    let xsl = new javax.xml.transform.stream.StreamSource(reader);
    templates = saxFactory.newTemplates(xsl);
    
   for (var i=0; i < siteNames.length; i++)
   {
      let xpath = `//element(*, ametys:content)[@ametys:site='${siteNames[i]}']`;
      Repository.query(xpath).forEach(function(content) {
        Content.migrate(
            content,
            __migrateRichTextsDataInContent,
            false,
            null,
            false,
            true
        );
      });
      logger.info(`Migrate docbook for ${handledVersions} versions of contents for site '${siteNames[i]}'`);
  }
}
finally
{
    IOUtils.closeQuietly(reader);
}
  
  
  
function __migrateRichTextsDataInContent(content)
{
    if (content.hasValue("content"))
    {
      var richText = content.getValue("content");
      __migrateRichTextData(richText);
      content.setValue("content", richText);
      handledVersions++;
    }
}
  
function __migrateRichTextData(richText)
{
    let inputStream = null;
    let outputStream = null;
    try
    {
        let transformer = templates.newTransformer();
        
        inputStream = richText.getInputStream();
        outputStream = richText.getOutputStream();
        
        let source = new javax.xml.transform.stream.StreamSource(inputStream);
        let result = new javax.xml.transform.stream.StreamResult(outputStream);

        transformer.transform(source, result);
    }
    finally
    {
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
    }
}
  
  
  