<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:import href="skin://services/link-directory/pages/services/directory/directory_1.0.xsl"/>
    
    <xsl:variable name="divIdPrefix">requests</xsl:variable>
    <xsl:variable name="cssClassPrefix">ametys-requests</xsl:variable>
    <xsl:variable name="cssCardBody">px-0 pt-0</xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-requests/scss/main.css')}" media="screen, print, handheld"/>
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-requests/scss/print.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:template name="card-header-default-title">
        <i18n:text i18n:key="SKIN_MY_REQUESTS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons star"></span>
    </xsl:template>
    
    <xsl:template name="links">
        <ol class="{$cssClassPrefix}"
            data-list="">
            <xsl:apply-templates select="/links/link[not(@unknownPage)]">
                <xsl:sort select="@user-selected='true'" order="descending"/>
                <xsl:with-param name="cssClassPrefix" select="$cssClassPrefix"/>
            </xsl:apply-templates>
        </ol>
    </xsl:template>
    
    <xsl:template name="data-settings-attribute">
        <xsl:attribute name="data-settings">
            <xsl:text>{
                 "listQty": {
                   "xs": 3,
                   "lg": 3
                 }
             }</xsl:text>
        </xsl:attribute>
    </xsl:template>
    
    <!-- No picture displayed -->
    <xsl:template name="link-picture"/>
</xsl:stylesheet>
