<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        extension-element-prefixes="resolver ametys filenameutils">
    
    <xsl:import href="plugin:user-directory://pages/services/insert-ud-user/view.xsl"/>  

    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/contact/scss/main.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="card mb-4">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
        
            <xsl:call-template name="common-service-body-nonempty-content-content"/>
        </div>
    </xsl:template>   

    <xsl:template name="common-service-body-nonempty-content-title">
        <header class="card-header justify-content-between pb-0 align-items-center">
            <h1 class="card-title mb-0">
                <xsl:call-template name="card-header-icon"/>
                <xsl:value-of select="$header"/>
            </h1>
        </header>
   </xsl:template>
   
   <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons">contacts</span>
   </xsl:template>

    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="card-body pt-0 pb-4 px-0">
           <xsl:variable name="raw-is-title-visible">
                <xsl:call-template name="common-service-body-nonempty-content-title-content">
                    <xsl:with-param name="title" select="$header"/>
                </xsl:call-template>  
            </xsl:variable>
                
            <xsl:apply-templates select="/content/html/body/node()" mode="move-hierarchy">
                <xsl:with-param name="level">
                    <xsl:choose>
                        <xsl:when test="$raw-is-title-visible != ''">2</xsl:when>
                        <xsl:otherwise>1</xsl:otherwise>
                    </xsl:choose>
                </xsl:with-param>
            </xsl:apply-templates>  
       </div>
    </xsl:template>

</xsl:stylesheet>