<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="resolver">

    <xsl:import href="plugin:web://pages/frontoffice-login/login.xsl"/>
	
    <xsl:template name="body-title">
    	<header class="card-header">
            <h1 class="ametys-content-title"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/></h1>
	    </header>
    </xsl:template>	
    
    <xsl:template name="body">
	    <xsl:call-template name="body-title"/>
	
		<div class="card-body ametys-cms-content wrapper">
			<xsl:call-template name="body-existingaccount-title"/>
			
			<xsl:call-template name="show-hint"/>
			<xsl:call-template name="show-errors"/>
			<xsl:call-template name="login"/>
        </div>
        
        <xsl:call-template name="signup"/>
	</xsl:template>
    
</xsl:stylesheet>
