<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
                
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:template name="common-service-head-css">    
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-quoi-de-neuf/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/document/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_AGENDA" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons local_library"></span>
    </xsl:template>
    
    <xsl:template name="hits-class-attribute">
        <xsl:attribute name="class">ametys-quio</xsl:attribute>
    </xsl:template>
	
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-quio__item<xsl:text> </xsl:text>
    </xsl:template>   
    
     <xsl:template name="hit">
        <li>
            <xsl:call-template name="hit-attributes"/>
            <xsl:apply-templates select="content/html" mode="content"/>
        </li>
    </xsl:template>
    
    <xsl:template match="html" mode="content">
        <xsl:variable name="page-id" select="head/meta[@name = 'pages/page;id']/@content"/>
        <div class="ametys-cms-content home-view news">
            <xsl:choose>
                <xsl:when test="$page-id != ''">
                    <a class="ametys-quio__link" href="{resolver:resolve('page', $page-id, false)}">
                        <xsl:apply-templates select="." mode="inner-content"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <div class="ametys-quio__link"> 
                        <xsl:apply-templates select="." mode="inner-content"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="html" mode="inner-content">
        <article>
            <xsl:apply-templates select="." mode="image"/>
            <xsl:apply-templates select="." mode="date"/>
            <xsl:apply-templates select="." mode="title"/>
        </article>
    </xsl:template>
    
    <xsl:template match="html" mode="image">
        <xsl:variable name="imgType" select="head/meta[@name = 'illustration/image;type']/@content"/>        
        <xsl:variable name="imgPath" select="head/meta[@name = 'illustration/image;path']/@content"/>
        <xsl:variable name="imgUrl"><xsl:value-of select="$imgPath"/><xsl:if test="$imgType = 'attribute'">?contentId=<xsl:value-of select="../@id"/></xsl:if></xsl:variable>
        
        <div class="ametys-quio__link_img">
            <xsl:choose>
                <xsl:when test="$imgType != ''">
                    <img src="{resolver:resolveCroppedImage($imgType, $imgUrl, '244', '424')}" alt=""/>
                </xsl:when>
                <xsl:otherwise>
                    <div class="ametys-document__img"/>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:apply-templates select="." mode="category"/>
        </div>
    </xsl:template>
    
    <xsl:template match="html" mode="title">
        <xsl:variable name="title" select="head/meta[@name = 'title']/@content"/>
        
        <h2 class="ametys-quio__title">
			<xsl:value-of select="$title" />
		</h2>
    </xsl:template>
    
    <xsl:template match="html" mode="date">
        <xsl:variable name="start-date" select="head/meta[@name = 'start-date']/@content"/>
        
        <div>
			<div class="ametys-quio__date">
				<span class="ametys-date__icon material-icons access_time"></span>
				<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="long"><xsl:value-of select="$start-date"/></i18n:date>
			</div>
		</div>
    </xsl:template>
    
    <xsl:template match="html" mode="category">
        <xsl:if test="head/meta[@content='CONTENT_CATEGORIES' and contains(@name, ';parent')]">
            <!-- Get first tag of CONTENT_CATEGORIES theme -->
			<xsl:variable name="parentTagName" select="head/meta[@content='CONTENT_CATEGORIES' and contains(@name, ';parent')]/@name"/> 
            <!-- Get tag name in meta  -->
            <xsl:variable name="tagMetaName" select="substring-before($parentTagName, ';parent')"/>
            <!-- Extract tag's name -->
			<xsl:variable name="tagName" select="substring-after($tagMetaName, 'tags/')"/>
       
	       <span class="ametys-quio__link_img_txt">
	            <xsl:if test="$useTagColor">
                    <xsl:variable name="tagColor" select="ametys:tagColor(ametys:site(), $tagName)/main"/>
	                <xsl:if test="$tagColor">
                        <xsl:attribute name="style">background-color : <xsl:value-of select="$tagColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                    </xsl:if>
	            </xsl:if>
	           
	            <xsl:value-of select="head/meta[@name = $tagMetaName]/@content"/>
	        </span>
	        
        </xsl:if>
    </xsl:template>
	
</xsl:stylesheet>
