<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="ametys">

    <xsl:import href="plugin:web://stylesheets/content/article/article-main.xsl"/>  
    
    <xsl:variable name="common-content-css-class-name"> 
        <xsl:choose>
            <xsl:when test="$zone = 'aside'"> article view-main card mb-4 </xsl:when>
            <xsl:otherwise> article view-main </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
       <!-- +
         | BODY
         + -->
    <!-- The content HTML structure -->
    <xsl:template name="common-content-body">
        <xsl:choose>
            <xsl:when test="$template = 'index'">
                <div class="ametys-cms-content card mb-4 article wrapper">
                    <xsl:call-template name="common-content-body-content"/>
                </div>
            </xsl:when>
            <xsl:when test="$zone = 'aside'">
                <div class="ametys-cms-content ametys-tools card mb-4 article wrapper">
                    <xsl:call-template name="common-content-body-content"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-cms-content {$common-content-css-class-name} wrapper">
                    <xsl:call-template name="common-content-body-title"/>
                    <xsl:call-template name="common-content-body-content"/>
                </div>
            </xsl:otherwise>
            </xsl:choose>    
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <xsl:choose>
            <xsl:when test="$template = 'index' or $zone = 'aside'">
                <div>
                    <header class="card-header">
                        <h1 class="card-title">
                            <xsl:call-template name="card-header-icon"/>
                            <xsl:value-of select="metadata/title"/>
                        </h1>
                        <xsl:call-template name="content-subtitle"/>
                    </header>
                    <!-- Rich content -->
                    <div class="ametys-richtext">
                        <xsl:call-template name="common-content-body-content-rich"/>
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="flex-center">
                    <!-- Tag -->
                    <xsl:call-template name="badge"/>
                    
                    <!-- Likes -->
                    <xsl:call-template name="content-likes"/>
                </div>
        
                <!-- Rich content -->
                <div class="ametys-richtext">
                    <xsl:call-template name="common-content-body-content-rich"/>
                </div>
                
                <!-- Contact, Publish date... -->
                <xsl:call-template name="common-content-body-meta"/>        
        
                <!-- Comments -->
                <xsl:call-template name="common-content-body-comments"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template> 
    
    <xsl:template name="content-subtitle">
        <xsl:if test="$zone = 'aside'">
            <span class="ametys-content-subtitle"><xsl:value-of select="metadata/document-subtitle"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <xsl:choose>
            <xsl:when test="$template = 'index'"><span class="card-header__icon material-icons live_tv"></span></xsl:when>
            <xsl:when test="$zone = 'aside'"><span class="card-header__icon material-icons">info</span></xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
