<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	xmlns:math="http://exslt.org/math"
	xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
	xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns:orgUnit="org.ametys.plugins.userdirectory.transformation.xslt.OrgUnitXSLTHelper"
	exclude-result-prefixes="ametys orgUnit resolver math">

    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>

	<xsl:template name="custom-content-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/profile/scss/main.css')}" media="screen, print, handheld" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/profile/scss/print.css')}" media="screen, print, handheld" />
	</xsl:template>
    
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content"/>
    </xsl:template> 

    <xsl:template name="common-content-body-title">
        <xsl:call-template name="common-content-body-title-content"/>
    </xsl:template>    
	
    <xsl:template name="common-content-body-title-content"/>
   
    <xsl:template name="common-content-body-content">
        <article class="ametys-profile">
            <xsl:call-template name="profile-header"/>
        
            <xsl:call-template name="profile-content"/>
        </article>
   </xsl:template>
   
   <xsl:template name="profile-header">
        <header class="ametys-profile-header">
            <xsl:call-template name="profile-header-img"/>
            
            <div class="ametys-profile-header__middle">
                <xsl:call-template name="profile-header-title"/>
                <xsl:call-template name="profile-header-function"/>
            </div>
        </header>
   </xsl:template>
   
   <xsl:template name="profile-header-img">
        <div data-ametys-metadata="{@id};illustration/image" class="ametys-profile-header__img_wrapper">
            <xsl:choose>
                <xsl:when test="metadata/illustration/image">
                    <xsl:call-template name="common-content-body-image-bigsize">
                        <xsl:with-param name="maxWidth" select="'140'" />
                        <xsl:with-param name="maxHeight" select="'140'" />
                        <xsl:with-param name="type" select="'cropped'"/>
                        <xsl:with-param name="class" select="'profil ametys-profile-header__img'" />
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="metadata/user">
                    <xsl:call-template name="user-profile-image">
                        <xsl:with-param name="size">140</xsl:with-param>
                        <xsl:with-param name="login" select="metadata/user/@login"/>
                        <xsl:with-param name="population" select="metadata/user/@populationId"/>
                        <xsl:with-param name="lang" select="@language"/>
                        <xsl:with-param name="class">profil ametys-profile-header__img</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <div class="content-illustration ametys-profile-header__img empty edit_user">
                        <img src="{ametys:skinURL('templates/common/img/avatar.png')}" width="140" height="140"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </div>
   </xsl:template>
   
   <xsl:template name="profile-header-title">
        <h1 class="ametys-profile__title">
            <span class="service-title">
                <xsl:if test="metadata/civilite">
                    <xsl:value-of select="metadata/civilite" />
                    <xsl:text> </xsl:text>
                </xsl:if>
                <xsl:value-of select="metadata/firstname" />
                <xsl:text> </xsl:text>
                <xsl:value-of select="metadata/lastname" />
            </span>
        </h1>
   </xsl:template>
   
   <xsl:template name="profile-header-function">
        <xsl:if test="metadata/function">
            <h2 class="ametys-profile__subtitle ametys-editable editable--text" data-ametys-metadata="{@id};function">
                <xsl:value-of select="metadata/function"/>
            </h2>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-content">
        <div class="ametys-profile-body">
            <ul class="ametys-categories">
                <xsl:call-template name="profile-organisation"/>
                <xsl:call-template name="profile-phones"/>
                <xsl:call-template name="profile-email"/>
                <xsl:call-template name="profile-skills"/>
                <xsl:call-template name="profile-professional-history"/>
                <xsl:call-template name="profile-hobbies"/>
            </ul>
        </div>
   </xsl:template>
   
   <xsl:template name="profile-organisation">
        <xsl:if test="metadata/organisation">
			<li class="ametys-categories__item">
                <span class="ametys-categories__item-icon"><i class="fa fa-briefcase"></i></span>
				<div class="ametys-categories__item-description">
					<h3 class="ametys-categories__item-title ametys-editable editable--text" data-ametys-metadata="{@id};organisation">
                        <xsl:value-of select="metadata/organisation" />
					</h3>
                    <xsl:if test="metadata/mission">
                        <p class="ametys-categories__item-text ametys-editable editable--text" data-ametys-metadata="{@id};mission">
                            <xsl:value-of select="metadata/mission" />
                        </p>
                    </xsl:if>
				</div>
                
			</li>
		</xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-phones">
        <xsl:if test="metadata/phone or metadata/mobile">
            <li class="ametys-categories__item">
                <span class="ametys-categories__item-icon"><i class="fa fa-phone"></i></span>
                <div class="ametys-categories__item-description">
                    <h3 class="ametys-categories__item-title">
                        <i18n:text i18n:key="SKIN_MEMBER_PHONES" i18n:catalogue="skin.{$skin}"/>
                    </h3>
                    <p class="ametys-categories__item-text">
                        <xsl:if test="metadata/phone">
                            <span>
                                <i18n:text i18n:key="SKIN_MEMBER_PHONE" i18n:catalogue="skin.{$skin}"/><xsl:text>: </xsl:text>
                                <a href="tel:{metadata/phone}" class="ametys-editable editable--text editable--text--inline" data-ametys-metadata="{@id};phone">
                                   <xsl:value-of select="metadata/phone" />
                                </a>
                            </span>
                            <xsl:if test="metadata/mobile"><br/></xsl:if>
                        </xsl:if>
                        <xsl:if test="metadata/mobile">
                            <span>
                                <i18n:text i18n:key="SKIN_MEMBER_MOBILE" i18n:catalogue="skin.{$skin}"/><xsl:text>: </xsl:text>
                                <a href="tel:{metadata/mobile}" class="ametys-editable editable--text editable--text--inline" data-ametys-metadata="{@id};mobile">
                                    <xsl:value-of select="metadata/mobile" />
                                </a>
                            </span>
                        </xsl:if>
                    </p>
                </div>
            </li>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-email">
        <xsl:if test="metadata/email">
            <li class="ametys-categories__item">
                <span class="ametys-categories__item-icon"><i class="fa fa-envelope"></i></span>
                <div class="ametys-categories__item-description">
                    <h3 class="ametys-categories__item-title">
                        <i18n:text i18n:key="SKIN_MEMBER_MAIL" i18n:catalogue="skin.{$skin}"/>
                    </h3>
                    <p class="ametys-categories__item-text">
                        <xsl:call-template name="mail-antispam">
                            <xsl:with-param name="mail"
                                select="metadata/email" />
                            <xsl:with-param name="class" select="'user-mail'" />
                            <xsl:with-param name="showIcon" select="false()" />
                        </xsl:call-template>
                    </p>
                </div>
            </li>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-skills">
        <xsl:if test="metadata/skills">
            <li class="ametys-categories__item">
                <span class="ametys-categories__item-icon"><i class="fas fa-medal"></i></span>
                <div class="ametys-categories__item-description">
                    <h3 class="ametys-categories__item-title">
                        <i18n:text i18n:key="SKIN_MEMBER_SKILLS" i18n:catalogue="skin.{$skin}"/>
                    </h3>
                    
                    <ul class="content-tags ametys-editable editable--contenttags" data-ametys-metadata="{@id};skills">
                        <xsl:for-each select="metadata/skills">
                            <li class="content-tags__item">
                                <xsl:value-of select="@title"/>
                            </li>
                        </xsl:for-each>
                    </ul>
                </div>
            </li>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-professional-history">
        <xsl:if test="metadata/professional-history/docbook:article">
            <li class="ametys-categories__item">
                <span class="ametys-categories__item-icon"><i class="fas fa-layer-group"></i></span>
                <div class="ametys-categories__item-description">
                    <h3 class="ametys-categories__item-title">
                        <i18n:text i18n:key="SKIN_MEMBER_PROFESSIONAL_HISTORY" i18n:catalogue="skin.{$skin}"/>
                    </h3>
                    <div class="ametys-categories__item-text ametys-editable editable--richtext" data-ametys-metadata="{@id};professional-history">  
                        <xsl:apply-templates select="metadata/professional-history/docbook:article">
                            <xsl:with-param name="level" select="2"/>
                        </xsl:apply-templates>
                    </div>
                </div>
            </li>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-hobbies">
        <xsl:if test="metadata/hobbies/docbook:article">
            <li class="ametys-categories__item">
                <span class="ametys-categories__item-icon"><i class="fas fa-layer-group"></i></span>
                <div class="ametys-categories__item-description">
                    <h3 class="ametys-categories__item-title">
                        <i18n:text i18n:key="SKIN_MEMBER_HOBBIES" i18n:catalogue="skin.{$skin}"/>
                    </h3>
                    <div class="ametys-categories__item-text ametys-editable editable--richtext" data-ametys-metadata="{@id};hobbies">  
                        <xsl:apply-templates select="metadata/hobbies/docbook:article">
                            <xsl:with-param name="level" select="2"/>
                        </xsl:apply-templates>
                    </div>
                </div>
            </li>
        </xsl:if>
   </xsl:template>
   
</xsl:stylesheet>
