<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	    xmlns:docbook="http://docbook.org/ns/docbook"
	    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
	    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	    xmlns:text="http://ametys.org/text/3.0" 
	    xmlns:exslt="http://exslt.org/common"
	    exclude-result-prefixes="docbook resolver ametys exslt"
	    extension-element-prefixes="text">

	<xsl:import href="plugin:news://stylesheets/content/news/news-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl" />
	
    <xsl:variable name="abstractTextMaxSize">300</xsl:variable>
    
	<xsl:variable name="common-content-css-class-name"> abstract-view news ametys-mb-20 </xsl:variable>
	
	<xsl:template name="common-content-body-title"/>
	
	<xsl:template name="content">
        
        <div>
        	<xsl:attribute name="class">ametys-document__img <xsl:if test="not(metadata/illustration/image)">ametys-document__img-no-img</xsl:if> ametys-document__img--play</xsl:attribute>
        		
            <xsl:call-template name="content-image"/>
        
            <xsl:call-template name="content-badge"/>
        </div>
        <div class="ametys-document__txt ametys-document__txt--limit">
            <xsl:call-template name="content-ctype"/>
            
            <xsl:call-template name="content-dates"/>
            
            <xsl:call-template name="content-title"/>
        
            <xsl:call-template name="content-abstract"/>
        </div>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image">
                    <xsl:with-param name="image" select="metadata/illustration/image"/>
                    <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                    <xsl:with-param name="maxWidth" select="'488'"/>
                    <xsl:with-param name="maxHeight" select="'328'"/>
                    <xsl:with-param name="class" select="''"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="content-default-image"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <span class="icofont-newspaper"></span>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <xsl:if test="metadata/start-date or metadata/end-date">
            <span class="ametys-document__date">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/start-date"/>
                    <xsl:with-param name="endDate" select="metadata/end-date"/>
                    <xsl:with-param name="isDatetime">false</xsl:with-param>
                </xsl:call-template>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-badge">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        <xsl:variable name="nb-tags"><xsl:value-of select="count(exslt:node-set($tags)/tag)"/></xsl:variable>
        
        <xsl:if test="exslt:node-set($tags)/tag">
        <div class="tags">
	        <xsl:for-each select="exslt:node-set($tags)/tag[position() = 1]">
	           <span class="tag" data-toggle="tooltip" data-placement="top" title="{.}">
					<xsl:if test="$useTagColor and @bgColor">
					   <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
					</xsl:if>
                    <xsl:value-of select="."/>
	           </span>
	        </xsl:for-each>
	        <xsl:if test="$nb-tags &gt; 1">
	            <span class="tag" data-toggle="tooltip" data-placement="top">
	            	<xsl:attribute name="title">
	            		<xsl:for-each select="exslt:node-set($tags)/tag[position() != 1]">
	            		    <xsl:value-of select="."/>
	            		    <xsl:if test="position() != $nb-tags - 1">
	            		    	<xsl:call-template name="tag-separator"/>
	            		    </xsl:if>
	            		</xsl:for-each>
	            	</xsl:attribute>
	            	
	            	<i18n:text i18n:key="CONTENT_NEWS_TAG_MORE" i18n:catalogue="skin.{$skin}"/>
	            	<xsl:value-of select="$nb-tags - 1"/>
	            </span>
	        </xsl:if>
	    </div>
	    </xsl:if>
     </xsl:template>
     
     <xsl:template name="tag-separator">, </xsl:template>
    
</xsl:stylesheet>