<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">

    <xsl:import href="skin://stylesheets/content/common-multimedia.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">home-view pdf-document </xsl:variable>
    
    <xsl:template name="content-icon">
        <i class="card-header__icon fas fa-file-pdf"></i>
    </xsl:template>
    
    <xsl:template name="content-link-attribute">
        <xsl:attribute name="href"><xsl:value-of select="resolver:resolve(concat(metadata/file/@type, '-flipbook'), metadata/file/@path)"/></xsl:attribute>
        <xsl:attribute name="title"><xsl:value-of select="metadata/file/@filename"/></xsl:attribute>
        <xsl:attribute name="target">_blank</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image">
                    <xsl:with-param name="image" select="metadata/illustration/image"/>
                    <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                    <xsl:with-param name="maxWidth" select="'239'"/>
                    <xsl:with-param name="maxHeight" select="'261'"/>
                    <xsl:with-param name="class" select="'ametys-document__img ametys-document__img--play'"/>
                    <xsl:with-param name="type" select="'bounded'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-document__img ametys-document__img--play">
                    <img src="{resolver:resolveBoundedImage(concat(metadata/file/@type, '-flipbook'), metadata/file/@path, 261, 239)}"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
                    
</xsl:stylesheet>