function openOrCloseMainMenuIfNeeded(currentStep, nextStep)
{
	let nextParams = nextStep['transitionParams'] || {};
    if (nextParams.type == "main-menu")
    {
		if (window.innerWidth <= 991 && !$j('body').hasClass('sidebar-is-toggled'))
		{
			$j('.ametys-header-invoker').trigger('click'); // open sidebar menu
			return 400;
		}
		else if (window.innerWidth > 991 && $j('body').hasClass('sidebar-is-toggled'))
		{
			$j('.ametys-header-invoker').trigger('click'); // open sidebar menu
			return 400;
		}
    }
	else if (window.innerWidth <= 991 && $j('body').hasClass('sidebar-is-toggled')) // sidebar menu is open
	{
		// close by clicking on the overlay to also dismiss the overlay
		$j('.ametys-overlay').trigger('click');
		return 400;
	}
    return 0;
}

function openOrCloseNotificationMenu(currentStep, nextStep)
{
	let nextParams = nextStep['transitionParams'] || {};
	if (nextParams.type == 'notifications')
	{
		if ($j('.ametys-header-action-invoker:not(.active)').is(':visible'))
        {
			$j('.ametys-header-action-invoker').trigger('click'); // open notification menu
        }
		return 200;
	}
	else if ($j('.ametys-header-action-invoker.active').is(':visible'))
	{
		// Close menu
		$j('.ametys-header-action-invoker').trigger('click'); // open notification menu
		return 200;
		
	}
	return 0;
}

function selectMainMenuItem(step)
{
	let params = step['transitionParams'] || {};
	let position = params.position || 1;
	
	return $j(`.ametys-sidebar-secondary-nav > li:nth-child(${position})`)[0];
}

AmetysFront.WelcomeTour.transitionFunction = function(currentStep, nextStep)
{
    let transitions = [openOrCloseMainMenuIfNeeded, openOrCloseNotificationMenu];
    let delays = transitions.map(t => t.apply(null, [currentStep, nextStep]))
    return Math.max(...delays);
}
