<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    extension-element-prefixes="resolver ametys">
    
    <xsl:import href="plugin:calendar://pages/services/search/fullcalendar.xsl"/>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="fullcalendar-css"/>
        
        <link rel="stylesheet" href="{ametys:skinURL('zones/fullcalendar/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="calendar-search-service-{$serviceId}">
            <xsl:call-template name="form-criteria" />

            <xsl:call-template name="search-results" />

            <div class="calendar-wrapper">
                <div id="calendar-{$serviceId}"></div>
                
                <xsl:call-template name="download-links" />
                
                <xsl:call-template name="loading-indicator" />
            </div>
        </div>
    </xsl:template>

    <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            
            <div class="flex-title">

                <xsl:call-template name="service-header" />

                <div class="flex-div">
                    <!-- Menu filter by categories -->
                    <xsl:if test="/search/form/tag-facet/tag">
                        <xsl:call-template name="tag-filter-menu" />
                    </xsl:if>

                    <xsl:call-template name="link" />
                </div>
            </div>
        
            <xsl:call-template name="form-criteria-hidden"/>
            
            <xsl:call-template name="ics-errors"/>
            
            <xsl:call-template name="hits"/>
        </div>
    </xsl:template>
    
    <xsl:template name="service-header">
        <h1 class="service-title">
            <xsl:value-of select="$header"/>
        </h1>
    </xsl:template>
    
    <xsl:template name="loading-indicator">
        <div class="loading" data-ametys-search-role="loading"><i class="fas fa-spinner"/></div>
    </xsl:template>
    
    <xsl:template name="download-links">
        <p>
            <xsl:call-template name="ics-link"/>
        </p>
    </xsl:template>
    
    <xsl:template name="tag-filter-menu">
        <xsl:if test="/search/form/tag-facet/tag">
            <!-- Open filter button -->
            <xsl:call-template name="tag-filter-button"/>

            <div class="dropdown-filter-calendar">
                <div class="dropdown-filter-icons">
                    <i class="fas fa-ellipsis-h"></i>
                    <i class="fa fa-times close" onclick="closeDropdownFilterCalendar(this)" aria-hidden="true"></i>
                </div>

                <xsl:call-template name="tag-filter-menu-title" />

                <div class="dropdown-content">
                    <div class="list-checkbox" data-ametys-search-role="tag-filter">
                        <xsl:apply-templates select="/search/form/tag-facet/tag" mode="tag-filter-menu">
                            <xsl:sort select="."/>
                        </xsl:apply-templates>
                    </div>
                </div>
            </div>
            
            <script type="text/javascript">
                function openDropdownFilterCalendar(el) {
                    $j(el).parent().find('.dropdown-filter-calendar').show();
                }
    
                function closeDropdownFilterCalendar(el) {
                    $j(el).closest('.dropdown-filter-calendar').hide();
                }
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="tag-filter-button">
        <!-- Open filter button -->
        <a href="javascript:void(0)" class="filter-calendar" onclick="openDropdownFilterCalendar(this)">
            <xsl:call-template name="tag-filter-button-icon"/>
            <i18n:text i18n:key="SKIN_SEARCH_EVENTS_FULLCALENDAR_PERSONNALIZE_LINK" i18n:catalogue="skin.{$skin}" />
        </a>
    </xsl:template>
    
    <xsl:template name="tag-filter-button-icon">
        <svg id="icon-reglages" xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
            <defs>
            </defs>
            <rect id="Rectangle_arrondi_560_copie" data-name="Rectangle arrondi 560 copie" class="cls-1" width="40" height="40"/>
            <path id="reglages" class="cls-2"
                d="M1286.18,1241.36a3.1,3.1,0,1,0-3.09,3.09A3.094,3.094,0,0,0,1286.18,1241.36Zm4.47-3.1a3.1,3.1,0,1,0,3.09,3.1A3.094,3.094,0,0,0,1290.65,1238.26Zm-15.13,0a3.1,3.1,0,1,0,3.1,3.1A3.094,3.094,0,0,0,1275.52,1238.26Z"
                transform="translate(-1263 -1221)" />
        </svg>
    </xsl:template>
    
    <xsl:template name="tag-filter-menu-title">
        <div class="dropdown-title">
            <i18n:text i18n:key="CALENDAR_SERVICE_SEARCH_FILTER_MENU_TITLE" i18n:catalogue="plugin.calendar"/>
        </div>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn">
                <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>