<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        extension-element-prefixes="resolver">

    <xsl:import href="plugin:link-directory://pages/services/directory/directory_1.0.xsl"/>
    <xsl:import href="plugin:link-directory://pages/services/directory/thumbnails_1.1.xsl"/>
    
    <xsl:variable name="is-empty" select="count(/links/link) = 0"/>    
    
    <xsl:variable name="number-showmore" select="3"/>
    
    <xsl:variable name="divIdPrefix">links</xsl:variable>
    <xsl:variable name="cssClassPrefix">ametys-links</xsl:variable>
    <xsl:variable name="cssCardBody">pt-0</xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-links/scss/main.css')}" media="screen, print, handheld"/>
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-links/scss/print.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        
        <div id="{$divIdPrefix}-{$uniqueId}">
            <xsl:if test="$template ='index'"><xsl:attribute name="class">card mb-4 <xsl:value-of select="$override-card-styles"/></xsl:attribute></xsl:if>
            <xsl:call-template name="data-settings-attribute"/>
            
            <xsl:call-template name="card-header"/>
            
            <xsl:call-template name="card-body"/>
            
            <xsl:if test="count(link) > $number-showmore">
                <xsl:call-template name="show-more-less-button"/>
            </xsl:if>
        </div>
        
        <script>
            setTimeout(function () {
                $j('#<xsl:value-of select="$divIdPrefix"/>-<xsl:value-of select="$uniqueId"/>').HSExpandableContent($j('#<xsl:value-of select="$divIdPrefix"/>-<xsl:value-of select="$uniqueId"/>').data('settings'));
            });
            
            $j(window).on('resize', function () {
                $j('#<xsl:value-of select="$divIdPrefix"/>-<xsl:value-of select="$uniqueId"/>').HSExpandableContent('update');
            });
        </script>
        
    </xsl:template>
    
    <xsl:template name="data-settings-attribute">
        <xsl:attribute name="data-settings">
            <xsl:text>{
                 "listQty": {
                   "xs": 4,
                   "lg": 1
                 }
             }</xsl:text>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template name="card-header">
        <header class="card-header">
            <h2 class="card-title">
                <xsl:call-template name="card-header-icon"/>
                <xsl:choose>
                    <xsl:when test="$header != ''">
                        <xsl:value-of select="$header"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="card-header-default-title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </h2>
        </header>
    </xsl:template>
    
    <xsl:template name="card-header-default-title">
        <i18n:text i18n:key="SKIN_LINKS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon icofont-ui-social-link"></span>
    </xsl:template>
    
    <xsl:template name="card-body">
        <div class="card-body {$cssCardBody}">
            <div class="{$cssClassPrefix}-wrap"
                 data-list-wrap="">
                
                <xsl:call-template name="links"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="links">
        <ul class="{$cssClassPrefix}"
            data-list="">
            <xsl:apply-templates select="/links/link[not(@unknownPage)]">
                <xsl:with-param name="cssClassPrefix" select="$cssClassPrefix"/>
                <xsl:sort select="@user-selected='true'" order="descending"/>
            </xsl:apply-templates>
        </ul>
    </xsl:template>
    
    
    <xsl:template name="show-more-less-button">
       <footer class="card-footer text-center"
               data-footer="">
           <span class="ametys-show-more"
                 data-toggle=""
                 data-default-text="skin.{$skin}:SKIN_DISPLAY_MORE" 
                 data-active-text="skin.{$skin}:SKIN_DISPLAY_LESS" i18n:attr="data-default-text data-active-text">
               <span class="ametys-show-more__text"
                     data-toggle-text=""><i18n:text i18n:key="SKIN_DISPLAY_MORE" i18n:catalogue="skin.{$skin}"/></span>
               <span class="ametys-show-more__icon material-icons expand_more"></span>
           </span>
       </footer>
    </xsl:template>
    
</xsl:stylesheet>       
