<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        extension-element-prefixes="resolver ametys filenameutils">
    
    <xsl:import href="plugin:web://pages/services/attach/attachments_small_3.3.xsl"/>
    <xsl:import href="skin://services/web/pages/services/common-photo-gallery.xsl"/>
    
	<xsl:param name="cms-context" select="ametys:siteUriPrefix()"/>
	<xsl:param name="contextPath" select="ametys:uriPrefix()"/>
    
	<xsl:template name="common-service-body-nonempty-content-content">
		<xsl:variable name="attachmentUrlPrefix" select="concat($cms-context, '/', page/@lang, '/', page/@path, '/_attachments')"></xsl:variable>
	
        <ul class="ametys-gallery-photo" id="gallery-photo-{$uniqueId">
            <xsl:apply-templates select="Folder|File"/>
        </ul>
	</xsl:template>

	<xsl:template match="Folder">
		<xsl:apply-templates select="Folder|File"/>
	</xsl:template>
	
	<xsl:template match="File">
        <xsl:if test="starts-with(@mimetype, 'image/')">
            <xsl:call-template name="photo-gallery-item">
                <xsl:with-param name="imgType">attachment-page</xsl:with-param>
                <xsl:with-param name="imgUri" select="@id"/>
                <xsl:with-param name="filename" select="@name"/>
            </xsl:call-template>
        </xsl:if>
	</xsl:template>     
     
</xsl:stylesheet>
