<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:math="http://exslt.org/math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template name="FolderIcon">
		<xsl:param name="state" />
		
		<xsl:choose>
			<xsl:when test="$state = 'closed'"><i class="fas fa-folder"></i></xsl:when>
			<xsl:otherwise><i class="fas fa-folder-open"></i></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Icons">
    	<xsl:variable name="name" select="filenameutils:getExtension(@name)"/>
    	<i>
    		<xsl:attribute name="class"><xsl:text>fas fa-</xsl:text>
    			<xsl:choose>
    				<xsl:when test="$name = 'doc' or $name = 'docx' or $name = 'dot'">file-word</xsl:when>
    				<xsl:when test="$name = 'avi' or $name = 'flv' or $name = 'mov' or $name = 'mpeg' or $name = 'mgp' or $name = 'swf' or $name = 'wmv'">file-video</xsl:when>
    				<xsl:when test="$name = 'bmp' or $name = 'gif' or $name = 'jpeg' or $name = 'jpg' or $name = 'png' or $name = 'psd' or $name = 'psp'">file-image</xsl:when>
    				<xsl:when test="$name = 'pdf'">file-pdf</xsl:when>
    				<xsl:when test="$name = 'pps' or $name = 'ppsx' or $name = 'ppt' or $name = 'pptx'">file-powerpoint</xsl:when>
    				<xsl:when test="$name = 'mid' or $name = 'mod' or $name = 'mp3'">file-audio</xsl:when>
    				<xsl:when test="$name = 'xls' or $name = 'xlsx'">file-excel</xsl:when>
    				<xsl:when test="$name = 'css' or $name = 'wml' or $name = 'xsl' or $name = 'htm' or $name = 'html' or $name = 'xhtml'">code</xsl:when>
    				<xsl:when test="$name = 'tar' or $name = 'rar' or $name = 'zip' or $name = 'tgz' or $name = 'jar'">archive</xsl:when>
    				<xsl:when test="$name = 'txt' or $name = 'odp' or $name = 'ods' or $name = 'odt' or $name = 'sxi' or $name = 'sxw'">file-alt</xsl:when>
					<xsl:when test="$name = 'cvs' or $name = 'sh' or $name = 'unkown' or $name = 'tgz' or $name = 'jar'">file</xsl:when>
    				<xsl:otherwise>file</xsl:otherwise>
    			</xsl:choose>
    		</xsl:attribute>
   		</i>
	</xsl:template>
</xsl:stylesheet>