<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							  xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              exclude-result-prefixes="ametys docbook resolver"
                              extension-element-prefixes="text">

     <xsl:import href="skin://stylesheets/content/common.xsl"/>
     
     <xsl:variable name="abstractTextMaxSize">50</xsl:variable>
     
     <xsl:variable name="common-content-css-class-name"> abstract-view article ametys-mb-20 </xsl:variable>
     
     <xsl:template name="common-content-body-title"/>
     
     <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}" class="ametys-document flex-column ametys-document--frame" data-ametys-page-link="true">
                    <xsl:call-template name="content"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-document flex-column ametys-document--frame">
                    <xsl:call-template name="content"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>     
    
    <xsl:template name="content">
        
        <div>
            <xsl:attribute name="class">ametys-document__img ametys-document__img--play</xsl:attribute>
                
            <xsl:call-template name="content-image"/>
        
            <xsl:call-template name="content-badge"/>
        </div>
        
        <div class="ametys-document__txt ametys-document__txt--limit">
            <xsl:call-template name="content-ctype"/>
            
            <xsl:call-template name="content-dates"/>
            
            <xsl:call-template name="content-title"/>
        
            <xsl:call-template name="content-abstract"/>
        </div>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image">
                    <xsl:with-param name="image" select="metadata/illustration/image"/>
                    <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                    <xsl:with-param name="maxWidth" select="288 * 1.1"/> <!-- x1.1 zoom effect on hover -->
                    <xsl:with-param name="maxHeight" select="164 * 1.1"/> <!-- x1.1 zoom effect on hover -->
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="content-default-image"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <span class="icon icofont-paper"></span>
    </xsl:template>
    
    <xsl:template name="content-badge">
        <!-- Tag -->
    </xsl:template>
    
    <xsl:template name="content-ctype"/>
    
    <xsl:template name="content-dates">
        <xsl:param name="startDate" select="metadata/start-date"/>
        <xsl:param name="endDate" select="metadata/end-date"/>
        <xsl:param name="hideDate" select="metadata/hide-date"/>
        
        <!-- Dates -->
        <xsl:choose>
            <xsl:when test="($startDate != '' or $endDate != '') and not($hideDate = 'true')">
                <span class="ametys-document_icn font-italic">
                    <xsl:call-template name="dates">
                        <xsl:with-param name="startDate" select="metadata/start-date"/>
                        <xsl:with-param name="endDate" select="metadata/end-date"/>
                        <xsl:with-param name="isDatetime">false</xsl:with-param>
                    </xsl:call-template>
                </span>
            </xsl:when>
            <xsl:when test="@lastValidatedAt">
                <!-- Use validation date by default -->
                <span class="ametys-document_icn font-italic">
                    <i class="material-icons">access_time</i>
                    <i18n:text i18n:key="CONTENT_VIEW_LASTPUBLICATIONDATE" i18n:catalogue="skin.{$skin}"/>
                    
                    <xsl:text> </xsl:text> 
                    <xsl:call-template name="common-utils-date-pattern">
                        <xsl:with-param name="date" select="@lastValidatedAt"/>
                    </xsl:call-template>                
                </span>    
            </xsl:when>   
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-title">
        <h1 class="ametys-document__txt_title">
            <xsl:value-of select="metadata/title"/>
        </h1>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">ametys-document__paragraph</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="$abstractTextMaxSize" />
        </xsl:call-template>
    </xsl:template>
    
    <!-- Template used for date format -->
    <xsl:template name="common-utils-date-pattern">
        <xsl:param name="date"/>
        
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="medium"><xsl:value-of select="$date"/></i18n:date>
    </xsl:template>   
	
</xsl:stylesheet>
    