<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text exslt">
    
    <xsl:import href="plugin:multimedia://stylesheets/content/document/document-main.xsl"/>		
	<xsl:import href="skin://stylesheets/content/document/document.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">main-view document ametys-mb-60</xsl:variable>
    
    <xsl:template name="common-content-body-title-content"/>
    
	<xsl:template name="common-content-body-content">
		<!-- Start: document -->
          <div class="ametys-document">
            <xsl:call-template name="document-image"/>
            <xsl:call-template name="document-header"/>
          </div>
          
          <xsl:call-template name="document-content"/>
          
          <xsl:call-template name="document-preview"/>
          <xsl:call-template name="document-download"/>
        <!-- END: document -->
    </xsl:template>
    
    <xsl:template name="document-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <xsl:call-template name="common-content-body-image-bigsize">
                <xsl:with-param name="class">ametys-document__img</xsl:with-param>
                <xsl:with-param name="type">bounded</xsl:with-param>
                <xsl:with-param name="maxWidth" select="'244'"/>
                <xsl:with-param name="maxHeight" select="'164'"/>
            </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-document__img">
                    <xsl:call-template name="content-default-image"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <span class="icofont-ui-copy"></span>
    </xsl:template>
    
    <xsl:template name="document-header">
         <div class="ametys-document__txt">
            <xsl:call-template name="document-category"/>
            <xsl:call-template name="document-type"/>
            <xsl:call-template name="document-title"/>
        </div>
    </xsl:template>
    
    <xsl:template name="document-category">
        <!-- Tag -->
        <xsl:call-template name="badge"/>
    </xsl:template>
    
    <xsl:template name="document-type">
        <div class="ametys-document__txt_name"><i18n:text i18n:key="SKIN_DOCUMENT_TYPE" i18n:catalogue="skin.{$skin}"/></div>
    </xsl:template>
    
    <xsl:template name="document-title">
        <h1 class="ametys-document__txt_title"><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <xsl:template name="document-content">
        <xsl:if test="metadata/content">
          <div>
            <xsl:call-template name="common-content-body-content-rich">
            	<xsl:with-param name="level">1</xsl:with-param>
            </xsl:call-template>
          </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="document-download">
    	<xsl:if test="metadata/file/@type">
          <a href="{resolver:resolve(metadata/file/@type, metadata/file/@path, true())}" title="{metadata/file/@filename} ({metadata/file/@size})" class="ametys-document__download">
                <xsl:call-template name="document-icon"/>
                <i18n:text i18n:key="SKIN_DOCUMENT_DOWNLOAD" i18n:catalogue="skin.{$skin}"/>
                <span class="ametys-document__download_lnk">
                  <i class="material-icons">vertical_align_bottom</i>
                </span>
          </a>
        </xsl:if>
     </xsl:template>
     
     <xsl:template name="document-preview">
     	<xsl:if test="metadata/file/@type">
          <a href="{resolver:resolve(concat(metadata/file/@type, '-flipbook'), metadata/file/@path)}" title="{metadata/file/@filename} ({metadata/file/@size})" class="ametys-document__download" target="_blank">
            <xsl:call-template name="document-icon"/>
            <i18n:text i18n:key="SKIN_DOCUMENT_PREVIEW" i18n:catalogue="skin.{$skin}"/>
            <span class="ametys-document__download_lnk">
              <i class="material-icons">remove_red_eye</i>
            </span>
          </a>
        </xsl:if>
     </xsl:template>
     
     <xsl:template name="document-icon">
        <xsl:choose>
            <xsl:when test="metadata/file/@mime-type = 'application/pdf'"><i class="fa fa-file-pdf"></i></xsl:when>
            <xsl:when test="contains(metadata/file/@mime-type, 'presentation')"><i class="far fa-file-powerpoint"></i></xsl:when>
            <xsl:when test="contains(metadata/file/@mime-type, 'image/')"><i class="far fa-file-image"></i></xsl:when>
            <xsl:when test="contains(metadata/file/@mime-type, 'video/')"><i class="far fa-file-video"></i></xsl:when>
            <xsl:when test="contains(metadata/file/@mime-type, 'spreadsheet')"><i class="far fa-file-excel"></i></xsl:when>
            <xsl:otherwise><i class="fa fa-file-alt"></i></xsl:otherwise>
        </xsl:choose>
     </xsl:template>
     
    <!--  overloaded to modify the class -->
     <xsl:template name="badge">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
        <xsl:for-each select="exslt:node-set($tags)/tag[position() &lt;= 3]">
            <span class="ametys-document__txt_badge">
                <xsl:if test="$useTagColor and @bgColor">
                    <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                </xsl:if>
                <xsl:value-of select="." />
           </span>
        </xsl:for-each>
    </xsl:template>
	
</xsl:stylesheet>
