<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">

	<xsl:import href="plugin:web://stylesheets/content/article/article-abstract.xsl"/>
	
    <xsl:template name="common-content-body">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:call-template name="content-dates"/>
            <xsl:call-template name="content-title"/>
            <xsl:call-template name="content-abstract"/>
        </a>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <!-- Dates -->
        <xsl:if test="(metadata/start-date or metadata/end-date) and not(metadata/hide-date = 'true')">
            <span class="link-info-date">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/start-date"/>
                    <xsl:with-param name="endDate" select="metadata/end-date"/>
                    <xsl:with-param name="isDatetime">false</xsl:with-param>
                </xsl:call-template>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-title">
        <span class="link-info-title">
            <xsl:value-of select="metadata/title"/>
        </span>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">link-info-summary</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="100" />
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>
