<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">
    
    <xsl:import href="plugin:job-offer://stylesheets/content/jobOffer/jobOffer-main.xsl"/>		
	<xsl:import href="jobOffer.xsl"/>
	
    <xsl:variable name="common-content-css-class-name">document view-main job-offer ametys-mb-60</xsl:variable>
    
    <xsl:template name="common-content-body-content">
    
        <div class="flex-center">
            <!-- Tag -->
           <xsl:call-template name="badge"/>
        </div>
                
        <xsl:call-template name="ref-id"/>
        
        <xsl:call-template name="job-description"/>
        <xsl:call-template name="job-profile"/>
        <xsl:call-template name="job-contacts"/>
        <xsl:call-template name="job-additional-info"/>

        <xsl:call-template name="closing-date"/>
        <xsl:call-template name="start-date"/>
        
        
        <script type="text/javascript">
            $j(function() {
                var $input = $j('.apply-form form .field input');
                $input.each(function() {
                    var $this = $j(this),
                        label = $this.closest('.field').find('.label label').text();
                        
                    $this.attr('placeholder', label);
                })
            });
        </script>
    </xsl:template>
    
    <xsl:template name="ref-id">
		<xsl:if test="metadata/refId">
			<p>
				<span class="content-subtitle2" style="font-weight:bold;">
					<i18n:text i18n:key="CONTENT_JOB_OFFER_ID" i18n:catalogue="plugin.job-offer" />
				</span>
				<xsl:text> </xsl:text>
				<xsl:value-of select="metadata/refId" />
			</p>
		</xsl:if>
	</xsl:template>
    
    <xsl:template name="job-description">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/content)">
            <p>
                <span class="content-subtitle" style="font-weight:bold;"><i18n:text i18n:key="CONTENT_JOB_OFFER_CONTENT" i18n:catalogue="plugin.job-offer" /></span>
            </p>
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/content" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-profile">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/requiredProfile)">
            <p>
                <span class="content-subtitle" style="font-weight:bold;"><i18n:text i18n:key="CONTENT_JOB_OFFER_PROFILE_REQUIRED" i18n:catalogue="plugin.job-offer" /></span>
            </p>
            
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/requiredProfile" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-contacts">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/contacts)">
            <p>
                <span class="content-subtitle" style="font-weight:bold;"><i18n:text i18n:key="CONTENT_JOB_OFFER_CONTACT" i18n:catalogue="plugin.job-offer" /></span>
            </p>
            
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/contacts" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-additional-info">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/additionalInfo)">
            <p>
                <span class="content-subtitle" style="font-weight:bold;"><i18n:text i18n:key="CONTENT_JOB_OFFER_ADDITIONAL_INFO" i18n:catalogue="plugin.job-offer" /></span>
            </p>
            
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/additionalInfo"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
	
    <xsl:template name="closing-date">
		<!-- Dates -->
        <xsl:if test="metadata/closingDate != ''">
        	<span class="ametys-time mb-4">
        		<i class="material-icons">access_time</i>
        	
        		<strong><i18n:text i18n:key="CONTENT_JOB_OFFER_CLOSING_DATE" i18n:catalogue="plugin.job-offer"/> : </strong>
				<div id="closing-date-{generate-id()}">
    	            <xsl:call-template name="dates">
    	                <xsl:with-param name="endDate" select="metadata/closingDate"/>
    	            </xsl:call-template>
		         </div>
	        </span><br />
	        
	        <script type="text/javascript">
        		var today = new Date(Date.now());
        		var endDate = new Date("<xsl:value-of select="metadata/closingDate"/>");
        		
        		if( endDate &lt; today){
        			$j("#closing-date-<xsl:value-of select="generate-id()"/>").append(" <i18n:text i18n:key="CONTENT_VIEW_ARCHIVED" i18n:catalogue="skin.{$skin}"/>");
        		}
        	</script>
        </xsl:if>
	</xsl:template>	
	
	<xsl:template name="start-date">
		<!-- Dates -->
        <xsl:if test="metadata/startDate != ''">
        	<span class="ametys-time mb-4">
        		<i class="material-icons">access_time</i>
        	
        		<strong><i18n:text i18n:key="CONTENT_JOB_OFFER_START_DATE" i18n:catalogue="plugin.job-offer"/> : </strong>
				<div id="start-date-{generate-id()}">
    	            <xsl:call-template name="dates">
    	                <xsl:with-param name="startDate" select="metadata/startDate"/>
    	            </xsl:call-template>
		         </div>
	        </span><br />
	        
	        <script type="text/javascript">
        		var today = new Date(Date.now());
        		var endDate = new Date("<xsl:value-of select="metadata/closingDate"/>");
        		
        		if( endDate &lt; today){
        			$j("#start-date-<xsl:value-of select="generate-id()"/>").append(" <i18n:text i18n:key="CONTENT_VIEW_ARCHIVED" i18n:catalogue="skin.{$skin}"/>");
        		}
        	</script>
	</xsl:if>
	</xsl:template>	
	
	<xsl:template name="date-format">
		<xsl:param name="date" />

		<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss"
			pattern="long">
			<xsl:value-of select="$date" />
		</i18n:date>
	</xsl:template>
	
	<xsl:template name="badge">
        <xsl:if test="metadata/contractType/@title">
            <span class="ametys-tag-v2 mb-4"><xsl:value-of select="metadata/contractType/@title"/></span>
        </xsl:if>
    </xsl:template>
	
</xsl:stylesheet>
