<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">
    
	<xsl:import href="skin://stylesheets/content/common-multimedia.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">home-view video </xsl:variable>
	
    <xsl:template name="content-link-class-attribute">
        <xsl:attribute name="class">ametys-webtv-list__item_link ametys-webtv--play ametys--video</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-link-attribute">
        <xsl:attribute name="href">#player-<xsl:value-of select="$uniqueId"/></xsl:attribute>
        <xsl:attribute name="id">video-link-<xsl:value-of select="$uniqueId"/></xsl:attribute>
        <xsl:attribute name="data-fancybox"></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-icon">
    	<i class="card-header__icon material-icons">play_arrow</i>
    </xsl:template>
    
    <xsl:template name="content-additional">
        <div class="ametys-video__modal">
            <video id="player-{$uniqueId}" class="ametys-video__modal_frame"></video>
        </div>
    </xsl:template>
    
    <xsl:template name="content-js">
        <script type="text/javascript">
              var videoPlayer<xsl:value-of select="$uniqueId"/>;

              $j(function() {
                $j("#video-link-<xsl:value-of select="$uniqueId"/>").fancybox({
                  beforeShow: function(){
                    videoPlayer<xsl:value-of select="$uniqueId"/> = new MediaElementPlayer('player-<xsl:value-of select="$uniqueId"/>', {
                      alwaysShowControls: true,
                      success: function(media) {
                        media.setSrc("<xsl:value-of select="resolver:resolve(metadata/file/@type, metadata/file/@path, 'true')"/>");
                        media.load();
                      }
                    });
                  },
                  afterShow: function() {
                    $j($j('#player-<xsl:value-of select="$uniqueId"/>')[0]).find('video').prop("controls", true)
                    $j('#player-<xsl:value-of select="$uniqueId"/>')[0].play();
                  },
                  beforeClose: function (){
                    videoPlayer<xsl:value-of select="$uniqueId"/>.remove();
                  }
                });
              });
        </script> 
    </xsl:template>
    
</xsl:stylesheet>
