<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:math="java.lang.Math" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              extension-element-prefixes="math ametys resolver">

    <xsl:import href="plugin:forms://pages/services/form-admin-dashboard/entry/edit.xsl"/>
 
    <xsl:template name="head-css-custom">
        <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/css/bootstrap-select.css')}" />
        
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/main.css')}" />
        
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/richtext.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/forms/scss/main.css')}"/>
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/forms-dashboard/scss/main.css')}"/>
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/forms-dashboard/scss/edit-iframe.css')}"/>
    </xsl:template>
    
    <xsl:template name="head-js-custom">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/jquery-migrate/jquery-migrate-3.5.2.js')}"></script>
        
        <script src="{ametys:skinURL('templates/common/plugins/bootstrap/bootstrap.min.js')}"></script>
        <script src="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/js/bootstrap-select.js')}"></script>
        
        <script src="{ametys:skinURL('templates/common/js/hs.core.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.dropdown.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.select.js')}"></script>
    </xsl:template>
    
    <xsl:template name="head-css-jquery">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/plugins/jquery/jquery-ui-1.11.4.css')}" media="screen, print, handheld"/>
    </xsl:template>
        
</xsl:stylesheet>