//
// Step Form
//
// Libraries: jQuery, jQuery Migrate, jQuery Validation

(function ($) {
  $().ready(function () {

      var $progressStepForm = $j('#progressStepForm'),
          $progressItems = $progressStepForm.find('.step'),
          currentStep = $progressStepForm.data('step');
          
      $('[data-next-step]').on('click', function (e) {
        e.preventDefault();

        // Valide form
        $j("div.field > div.error").each(function(e)
        {
            $j(this).remove()
            $j(this).find(".input").removeClass("invalid");
        });
        
        var hasError = false;
        
        hasError = checkMandatoryField($j('.field input[name=firstname]'), "{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_FIRSTNAME_EMPTY}}");
        hasError = checkMandatoryField($j('.field input[name=lastname]'), "{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_LASTNAME_EMPTY}}") || hasError;
        hasError = checkMandatoryField($j('.field input[name=password]'), "{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_PASSWORD_EMPTY}}") || hasError;
        
        // check password confirm        
        hasError = checkSamePassword() || hasError;
        
        // check strong password
        hasError = checkStrongPassword() || hasError;

        // check mandatory fields
        $j('.field .input [data-ametys-mandatory=true]').each(function() {
            hasError = checkMandatoryField(this) || hasError;
        });
        
    	if (hasError)
    	{
            // Scroll to top of the form
    		$('html, body').stop().animate({
                'scrollTop': $j('.field input[name=firstname]').offset().top - 40
            }, 800);
    		
    		return;
    	}
    	
        // Go to next step
        var $this = $(this),
          nextID = $this.data('next-step');

        // Active next step
        $progressItems.removeClass('active');
        $progressItems.filter('[data-to-step="' + nextID + '"]').addClass('active');
          
        // Hide form
        $j("#signUp").hide();
        $j("#signUp").removeClass('active');
        
        // Display CGU
        $(nextID).fadeIn(400);
        $(nextID).addClass('active');
        
        $(nextID).closest('form').parent().addClass('step-cgu');
        
        // Scroll to top
        $('html, body').stop().animate({
          'scrollTop': 0
        }, 800);
    });
    
    $('[data-precede-step]').on('click', function (e) {
        e.preventDefault();
        
        // Go to precede step
        var $this = $(this),
          precedeID = $this.data('precede-step');

        // Active next step
        $progressItems.removeClass('active');
        $progressItems.filter('[data-to-step="' + precedeID + '"]').addClass('active');
          
        // Hide CGU
        $j("#stepFormTermsOfUse").hide();
        $j("#stepFormTermsOfUse").removeClass('active');
        $j("#stepFormTermsOfUse").closest('form').parent().removeClass('step-cgu');
        
        // Display form
        $(precedeID).fadeIn(400);
        $(precedeID).addClass('active');
        
        // Scroll to top
        $('html, body').stop().animate({
          'scrollTop': 0
        }, 800);
    });

    $j('input[name = "firstname"]').on('change', function (e) {
        e.preventDefault();
        analyseEmptyField($j(this), "{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_FIRSTNAME_EMPTY}}");
    });
    
    $j('input[name = "lastname"]').on('change', function (e) {
        e.preventDefault();
        analyseEmptyField($j(this), "{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_LASTNAME_EMPTY}}");
    });
    
    $j('input[name = "password"]').on('change', function (e) {
        e.preventDefault();
        analyseEmptyField($j(this), "{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_PASSWORD_EMPTY}}");
    });

    // Listener on mandatory field
    $j('.field .input [data-ametys-mandatory=true]').each(function() {
        var $this = $j(this);
        
        $this.on('change', function(e) {
            e.preventDefault();
            analyseEmptyField($this);
        })
    });
  });
})(jQuery);

function checkSamePassword()
{
    var $passwordInput = $j('input[name = "password"]');
    var $passwordConfirmationInput = $j('input[name = "password-confirmation"]');
    
    var password = $passwordInput.val();
    var passwordConfirmation = $passwordConfirmationInput.val();
    
    if (password !== undefined && password !== "")
    {
        if (password != passwordConfirmation)
        {
            $passwordInput.closest('.input').addClass("invalid");
            
            var $field = $passwordInput.closest('.field');
            if ($field.find(".error").length == 0)
	        {
	            $field.prepend("<div class='error'>{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_PASSWORD_CONFIRMATION_DOESNT_MATCH}}</div>");
	        }
            
            return true;
        }
    }
    
    return false;
}

function checkStrongPassword()
{
    var $passwordInput = $j('input[name = "password"]');
    var invalidRequirements = $passwordInput.attr("data-pr-invalid");
    if (invalidRequirements == 'true')
    {
        $passwordInput.closest('.input').addClass("invalid");
            
        var $field = $passwordInput.closest('.field');
        if ($field.find(".error").length == 0)
        {
            $field.prepend("<div class='error'>{{i18n plugin.web:PLUGINS_WEB_USER_SIGNUP_ERROR_PASSWORD_WEAK_ERROR}}</div>");
        }
        
        return true;
    }
    
    return false;
}

function checkMandatoryField(input, errorMessage)
{
    var $this = $j(input),
        value = $this.val(),
        errorMessage = errorMessage || "{{i18n plugin.web:PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD_ERROR}}"
    
    if (value === undefined || value === "")
    {
        $this.closest('.input').addClass("invalid");
        
        var $field = $this.closest('.field');
        if ($field.find(".error").length == 0)
        {
            $field.prepend("<div class='error'>" + errorMessage + "</div>");
        }
        
        return true;
    }
    
    return false;
}

function analyseEmptyField(input, errorMessage)
{
    var $this = $j(input),
        value = $this.val(),
        errorMessage = errorMessage || "{{i18n plugin.web:PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD_ERROR}}"
        
	if (value === undefined || value === "")
    {
        $this.closest('.input').addClass("invalid");
        
        var $field = $this.closest('.field');
        if ($field.find(".error").length == 0)
        {
            $field.prepend("<div class='error'>" + errorMessage + "</div>");
        }
    }
    else
    {
        $this.closest('.input').removeClass("invalid");
    	$this.closest('.field').find(".error").remove();
    }
}