<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        extension-element-prefixes="resolver">

    <xsl:import href="plugin:link-directory://pages/services/directory/directory_1.0.xsl"/>
    <xsl:import href="plugin:link-directory://pages/services/directory/utils/thumbnails_utils.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">link-directory ametys-zone-nav-middle</xsl:variable>
    <xsl:variable name="buttonId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-head-css">
    	<!-- BEGIN styles for link directory config feature -->
        <link rel="stylesheet" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />
		<link rel="stylesheet" href="{ametys:skinURL('plugins/custombox/custombox.min.css')}" />
        <!-- END styles for link directory config feature -->
        <!-- BEGIN head-css-owl-carousel -->
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel.min.css')}" type="text/css" />
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel-defaut-theme.min.css')}" type="text/css" />
    	<!-- END head-css-owl-carousel -->
	</xsl:template>
	
	<xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
	    <script type="text/javascript" src="{ametys:skinURL('plugins/js/owl-carousel.min.js')}"></script>
	    <!-- BEGIN styles for link directory config feature -->
	    <script src="{ametys:skinURL('templates/common/js/ametys-tools.js')}"></script>
        <script src="{ametys:pluginResourceURL('link-directory', 'js/LinkDirectoryHelper.js')}" type="text/javascript"></script>
        <script src="{ametys:skinURL('plugins/web-animations-js/web-animations.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/hammerjs/hammer.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/muuri/dist/muuri.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/custombox/custombox.min.js')}"></script>
        <!-- END styles for link directory config feature -->
    	<xsl:call-template name="link-dynamic-info-js">
            <xsl:with-param name="themes" select="ametys:serviceParameter('themes')"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            
            <xsl:call-template name="common-service-body-nonempty-content-content"/>
                        
	    	<xsl:if test="$configurable = 'true'">
	            <xsl:call-template name="configure-links-dialog">
	                <xsl:with-param name="links" select="/links/link"/>
	                <xsl:with-param name="uniqueId" select="$uniqueId"/>
                    <xsl:with-param name="savingId" select="@zoneItemId"/>
	            </xsl:call-template>                                     
	        </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="wrapper">
           <div class="container">
           		<xsl:if test="$configurable = 'true'">
		            <!-- Configure button -->    
		            <xsl:call-template name="configure-links-btn">
		                <xsl:with-param name="uniqueId" select="$uniqueId"/>
		            </xsl:call-template>
				</xsl:if>
           			
		        <div id="link-directory-{$uniqueId}" class="owl-carousel owl-theme">
		        	
		            <xsl:apply-templates select="/links/link[@url != '' and @isHidden = 'false' and not(@unknownPage)]">
                    	<xsl:sort select="@user-selected='true'" order="descending"/>
                	</xsl:apply-templates>
		        </div>
		        
		    </div>
		</div>
		
		<script type="text/javascript">
            $j('.ametys-zone-nav-middle .owl-carousel').owlCarousel({
                loop: false,
                margin: 0,
                dots: false,
                nav: true,
                navText: [`&lt;a href="javascript:void();" class="arrow-left">
						    &lt;i class="fas fa-arrow-left">&lt;/i>
						&lt;/a>`, `&lt;a href="javascript:void();" class="arrow-right">
						    &lt;i class="fas fa-arrow-right">&lt;/i>
						&lt;/a>
						`],
                responsive: {
                    0: {
                        items: 2,
                        slideBy: 1,
                    },
                    525: {
                        items: 3,
                        slideBy: 1
                    },
                    670: {
                        items: 4,
                        slideBy: 1
                    },
                    820: {
                        items: 5,
                        slideBy: 1
                    }
                },
                slideBy: 1
            })
        </script>
    </xsl:template>
    
    <xsl:template match="link">
    	<div class="ametys-favorites-list__item" data-list-item="">
	    	<a href="" class="square ametys-favorites-list__link" data-list-link="" data-serverid="{@id}">
	    		<xsl:call-template name="link-url"/>
	    		<xsl:call-template name="link-dynamic-info">
                   <xsl:with-param name="uniqueId" select="$uniqueId" />
                </xsl:call-template>
	            <xsl:call-template name="link-picture"/>
	            <xsl:if test="normalize-space(@title) != ''">
	            	<span class="title"><xsl:value-of select="@title"/></span>
	            </xsl:if>
	        </a>
	    </div>
    </xsl:template>
    
    <xsl:template name="link-dynamic-info">
        <xsl:param name="uniqueId" select="$uniqueId" />
    	<span class="link-dynamic-info" id="{concat('link-info-', $uniqueId, '-', substring-after(@id, 'directoryLink://'))}"></span>
    </xsl:template>
    
    <xsl:template name="link-picture">
    	<xsl:choose>
    		<xsl:when test="@pictureType != '' and (@pictureId or @picturePath or @pictureGlyph)">
	            <xsl:call-template name="link-status" />
	            <xsl:choose>
	                <xsl:when test="@pictureType = 'glyph'">
	                    <i class="link-glyph {@pictureGlyph}"></i>
	                </xsl:when>
	                <xsl:otherwise>
	                    <xsl:variable name="id">
	                        <xsl:choose>
	                            <xsl:when test="@pictureType = 'resource'">
	                                <xsl:value-of select="@pictureId"/>
	                            </xsl:when>
	                            <xsl:when test="@pictureType = 'external'">
	                                <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
	                            </xsl:when>
	                        </xsl:choose>
	                    </xsl:variable>
	                        <span class="ametys-favorites-list__icon">
	                        	<img src="{resolver:resolveBoundedImage(@imageType, $id, 40, 40)}">
		                            <xsl:attribute name="alt"><xsl:value-of select="@pictureAlternative"/></xsl:attribute>
		                        </img>
		                    </span>
	                </xsl:otherwise>
	            </xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<i>
					<xsl:attribute name="class">acronym</xsl:attribute>
					<xsl:value-of select="substring(@title, 0, 3)"/>
				</i>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <xsl:template name="link-url">
    	<xsl:choose>
             <xsl:when test="@urlType = 'PAGE'">
                 <xsl:attribute name="href"><xsl:value-of select="resolver:resolve('page', @url)"/></xsl:attribute>
             </xsl:when>
             <xsl:otherwise>
                 <xsl:attribute name="onclick">window.open(this.href); return false;</xsl:attribute>
                 <xsl:attribute name="href"><xsl:value-of select="@url"/></xsl:attribute>
                 <xsl:attribute name="title"><xsl:value-of select="@alternative"/></xsl:attribute>
              </xsl:otherwise>
         </xsl:choose>
    </xsl:template>
    
    <xsl:template match="long-value"/>
    
    <xsl:template match="tooltip"/>

    <xsl:template match="item"/>

    <xsl:template match="title"/>

    <xsl:template match="summary"/>

</xsl:stylesheet>       
