<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:import href="plugin:link-directory://pages/services/directory/dynamic-info/default.xsl"/>
    
   <xsl:template match="dynamic-information[@id]">
        <dynamic-information id="{@id}">
            <xsl:if test="error">
                <xsl:attribute name="error"><xsl:value-of select="error/@type"/></xsl:attribute>
            </xsl:if>
            
            <xsl:if test="short-value != '0'">
            	<xsl:apply-templates select="short-value" />
            </xsl:if>
            
            <xsl:if test="not(error)">
                <div class="dropdown message">
                    <div class="space"></div>
                    
                    <xsl:if test="short-value = '0'"><xsl:attribute name="class">dropdown message empty</xsl:attribute></xsl:if>
                    
                    <ul>
                        <a href="#">
                            <xsl:apply-templates select="long-value" />
                        </a>
                        <xsl:if test="tooltip/item">
                            <xsl:apply-templates select="tooltip" />
                        </xsl:if>
                    </ul>
                </div>
            </xsl:if>
            
            <xsl:apply-templates select="error" />
        </dynamic-information>
    </xsl:template>
   
   <xsl:template match="long-value">
        <li>
            <xsl:apply-templates />
        </li>
    </xsl:template>
    
    <xsl:template match="tooltip">
        <xsl:apply-templates select="item" />
    </xsl:template>

    <xsl:template match="item">
        <li>
            <a href="#">
                <xsl:apply-templates select="title" />
                <xsl:apply-templates select="summary" />
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="summary">
        <span class="message">
            <xsl:apply-templates />
        </span>
    </xsl:template>
   
  <xsl:template match="short-value">
        <span class="link-info-short-value"></span>
    </xsl:template>
   
   <xsl:template match="error">
        <span class="link-info-error-message badge error"></span>
        <span class="link-info-error-message dropdown">
            <p><xsl:apply-templates /></p>
        </span>
    </xsl:template>
    
</xsl:stylesheet>