<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exsl="http://exslt.org/common"
                extension-element-prefixes="math resolver ametys">
    
   <xsl:import href="plugin:link-directory://pages/services/directory/thumbnails_1.1.xsl"/>
   
   <xsl:variable name="common-service-css-class-name">ametys-zone-in-one-click</xsl:variable>
   
   <!-- The service HTML structure when there is something in the service -->
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper" data-content="{$header}">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            
            <xsl:call-template name="common-service-body-nonempty-content-content"/>            
        </div>
    </xsl:template>
    
     <xsl:template name="common-service-body-nonempty-content-content">
        <!-- Display the links in thumbnails mode -->
        <xsl:call-template name="links-thumbnails">
        	<xsl:with-param name="cssClass" select="'links-list'"/>
            <xsl:with-param name="links" select="/links/link"/>
            <xsl:with-param name="moreThreshold" select="'6'"/>
            <xsl:with-param name="height" select="100"/>
            <xsl:with-param name="width" select="100"/>
            <xsl:with-param name="showThemes" select="ametys:serviceParameter('showThemes')/text()"/>
            <xsl:with-param name="showUrl" select="ametys:serviceParameter('showUrl')/text()"/>
        </xsl:call-template>
    </xsl:template>
    
    <!--  The links in thumbnails mode -->
    <xsl:template name="links-thumbnails">
        <xsl:param name="links"/>
        <xsl:param name="cssClass">links</xsl:param>
        <xsl:param name="moreThreshold"/>
        <xsl:param name="height" select="96"/>
        <xsl:param name="width" select="96"/>
        <xsl:param name="themes"/>
        <xsl:param name="showThemes"/>
        <xsl:param name="showUrl"/>
        <xsl:param name="showTitle">true</xsl:param>
        <xsl:param name="uniqueId" select="$uniqueId" />
        
        <xsl:variable name="links-raw">
            <xsl:call-template name="separate-links">
                <xsl:with-param name="links" select="$links"/>
                <xsl:with-param name="moreThreshold" select="$moreThreshold"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="separated-links" select="exsl:node-set($links-raw)"/>
        
        <!-- The first $moreThreshold links -->
        <ul class="{$cssClass}">
            <xsl:apply-templates select="$separated-links/primary/link" mode="thumbnails">
                <xsl:with-param name="height" select="$height"/>
                <xsl:with-param name="width" select="$width"/>
                <xsl:with-param name="showThemes" select="$showThemes"/>
                <xsl:with-param name="showUrl" select="$showUrl"/>
                <xsl:with-param name="showTitle" select="$showTitle"/>
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
            </xsl:apply-templates>     
        </ul>
            
        <!-- The remaining links -->
<!--         <xsl:if test="$separated-links/secondary"> -->
<!--         	<div class="{$cssClass} second-line" id="secondary-links-{$uniqueId}"> -->
<!-- 	            <ul class="container" id="secondary-links-{$uniqueId}"> -->
<!-- 		            <xsl:apply-templates select="$separated-links/secondary/link" mode="thumbnails"> -->
<!-- 		               <xsl:with-param name="height" select="$height"/> -->
<!-- 	                   <xsl:with-param name="width" select="$width"/> -->
<!-- 	                   <xsl:with-param name="showThemes" select="$showThemes"/> -->
<!-- 	                   <xsl:with-param name="showUrl" select="$showUrl"/> -->
<!-- 	                   <xsl:with-param name="showTitle" select="$showTitle"/> -->
<!-- 	                   <xsl:with-param name="uniqueId" select="$uniqueId"/> -->
<!-- 	                </xsl:apply-templates> -->
<!-- 	            </ul> -->
<!-- 	        </div> -->
<!--         </xsl:if> -->
        
        <xsl:variable name="inOneClickPage" select="ametys:findPagesIdsByTag('IN_ONE_CLICK')"/>
        
         <xsl:if test="$inOneClickPage/@id">
         	<div style="text-align: center">
        		<a class="button more-links" href="{resolver:resolve('page', $inOneClickPage/@id)}" style="display: inline-block;">
        			<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_MORE_LINKS" i18n:catalogue="skin.{$skin}"/>
        		</a>
        	</div>
        </xsl:if>
<!--          <xsl:if test="count($links) &gt; $moreThreshold"> -->
<!--              <xsl:call-template name="see-more-less"> -->
<!--                  <xsl:with-param name="height" select="$height"/> -->
<!--                  <xsl:with-param name="width" select="$width"/> -->
<!--                  <xsl:with-param name="buttonId" select="$uniqueId"/> -->
<!--              </xsl:call-template> -->
<!--          </xsl:if> -->
    </xsl:template>
    
    <xsl:template match="link[@url != '' and @isHidden = 'false']" mode="thumbnails">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="showThemes"/>
        <xsl:param name="showUrl"/>
        <xsl:param name="showTitle">true</xsl:param>
        <xsl:param name="uniqueId" select="$uniqueId"/>
        <li>
        	<xsl:choose>
                <xsl:when test="@disabled">
                    <xsl:attribute name="class"> <xsl:call-template name="common-utils-class"/> link-disabled</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class"> <xsl:call-template name="common-utils-class"/></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@urlType = 'PAGE'">
                    <a href="{resolver:resolve('page', @url)}" class="link">
                         <xsl:call-template name="link-status" />
                    
                         <xsl:call-template name="link-title">
                            <xsl:with-param name="showThemes" select="$showThemes"/>
                            <xsl:with-param name="showUrl" select="$showUrl"/>
                         </xsl:call-template>
                         <xsl:call-template name="link-picture">
                            <xsl:with-param name="height" select="$height"/>
                            <xsl:with-param name="width" select="$width"/>
                         </xsl:call-template>
                         <xsl:if test="$showTitle = 'true'">
                            <xsl:call-template name="link-text"/>
                         </xsl:if>
                       	 <xsl:call-template name="link-dynamic-info">
                       	    <xsl:with-param name="uniqueId" select="$uniqueId" />
                       	 </xsl:call-template>
                    </a>    
                </xsl:when>
                <xsl:otherwise>
                	<xsl:choose>
                    	<xsl:when test="@disabled">
                            <span class="link">
		                         <xsl:call-template name="link-title">
		                            <xsl:with-param name="showThemes" select="$showThemes"/>
		                            <xsl:with-param name="showUrl" select="$showUrl"/>
		                         </xsl:call-template>
		                         <xsl:call-template name="link-picture">
		                            <xsl:with-param name="height" select="$height"/>
		                            <xsl:with-param name="width" select="$width"/>
		                         </xsl:call-template>
		                         <xsl:if test="$showTitle = 'true'">
		                            <xsl:call-template name="link-text"/>
		                         </xsl:if>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                      		<a href="{@url}" onclick="window.open(this.href); return false;" class="link">
                      		     <xsl:call-template name="link-status" />
                      		
		                         <xsl:call-template name="link-title">
		                            <xsl:with-param name="showThemes" select="$showThemes"/>
		                            <xsl:with-param name="showUrl" select="$showUrl"/>
		                         </xsl:call-template>
		                         <xsl:call-template name="link-picture">
		                            <xsl:with-param name="height" select="$height"/>
		                            <xsl:with-param name="width" select="$width"/>
		                         </xsl:call-template>
		                         <xsl:if test="$showTitle = 'true'">
		                            <xsl:call-template name="link-text"/>
		                         </xsl:if>
	                         	 <xsl:call-template name="link-dynamic-info">
		                            <xsl:with-param name="uniqueId" select="$uniqueId" />
		                         </xsl:call-template>
		                    </a>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template name="link-picture">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        
        <xsl:if test="@pictureType != ''">
        	<xsl:choose>
        		<xsl:when test="@pictureType = 'glyph'">
        			<i class="picture link-glyph {@pictureGlyph}"></i>
        		</xsl:when>
        		<xsl:otherwise>
        			<xsl:variable name="id">
		                <xsl:choose>
		                    <xsl:when test="@pictureType = 'resource'">
		                        <xsl:value-of select="@pictureId"/>
		                    </xsl:when>
		                    <xsl:when test="@pictureType = 'external'">
		                        <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
		                    </xsl:when>
		                </xsl:choose>
		            </xsl:variable>
            
		            <span class="picture">
		                <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, $height, $width)}" alt="{@pictureAlternative}"/>
		            </span>
        		</xsl:otherwise>
        	</xsl:choose>
         </xsl:if>
    </xsl:template>
    
    <!-- The see more/less links functionality -->
    <xsl:template name="see-more-less">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        <xsl:param name="buttonId"/>
        
        <script type="text/javascript">
            
            <xsl:call-template name="show-more-picture">
                <xsl:with-param name="height" select="$height"/>
                <xsl:with-param name="width" select="$width"/>
            </xsl:call-template>
            
            <xsl:call-template name="show-less-picture">
                <xsl:with-param name="height" select="$height"/>
                <xsl:with-param name="width" select="$width"/>
            </xsl:call-template>
            
           const moreLinks = () => {
	            $j('.links-list.second-line').slideDown();
	            $j('.more-links').hide();
	            $j('.less-links').fadeIn();
	        }
	
	        const lessLinks = () => {
	            $j('.links-list.second-line').slideUp();
	            $j('.more-links').fadeIn();
	            $j('.less-links').hide();
	        }
        </script>
    </xsl:template>
    
    <xsl:template name="show-less-picture">
        document.write("&lt;button class=\"button more-links\" onclick=\"moreLinks()\"&gt;<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_MORE" i18n:catalogue="plugin.link-directory"/>&lt;/button&gt;");
    </xsl:template>
   
    <xsl:template name="show-more-picture">
        document.write("&lt;button class=\"button less-links\" style=\"display: none;\" onclick=\"lessLinks()\"&gt;<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LESS" i18n:catalogue="plugin.link-directory"/>&lt;/button&gt;");
    </xsl:template>
    
</xsl:stylesheet>
