<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:linkDirectory="org.ametys.plugins.linkdirectory.LinkDirectoryXSLTHelper"
        		extension-element-prefixes="resolver">
                
    <xsl:import href="plugin:link-directory://pages/services/directory/utils/config_utils.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Default rendering for a service -->
    <xsl:template name="configure-links-btn">
        <xsl:param name="uniqueId" select="$uniqueId"/>
        
        <xsl:if test="ametys:user()">
            <a class="settings" onclick="openModalOutils_{$uniqueId}(this)" href="javascript:void()" title="plugin.link-directory:PLUGINS_LINKDIRECTORY_CONFIGURE_LINKS_TITLE" i18n:attr="title"><i class="fas fa-cog"></i></a>
        </xsl:if>
        
        <script>
            var openedModalOutils = 0;
            function openModalOutils_<xsl:value-of select="$uniqueId"/>() {
                $j('.overlay, .ametys-zone-modal-settings').addClass('active');
                if (openedModalOutils == 0) {
                    setTimeout(function () {
                        var $tool = $j('#tool-ametys_<xsl:value-of select="$uniqueId"/>');
                        $tool.HSAmetysTools($j('#tool-ametys_<xsl:value-of select="$uniqueId"/>').data('settings'));
            
                        $tool.on('elementDeactivated', deactivateLink_ametys_<xsl:value-of select="$uniqueId"/>);
                        $tool.on('elementActivated', activateLink_ametys_<xsl:value-of select="$uniqueId"/>);
                        $tool.on('elementMoved', moveLink_ametys_<xsl:value-of select="$uniqueId"/>);
                        $tool.on('elementDeleted', deleteLink_ametys_<xsl:value-of select="$uniqueId"/>);
                        $j("#tool-toggle-ametys_<xsl:value-of select="$uniqueId"/>").trigger('click');
                    }, 200);
                }
                openedModalOutils++;
            }
            
            function closeModalOutils_<xsl:value-of select="$uniqueId"/>() {
                $j('.overlay, .ametys-zone-modal-settings').removeClass('active');
                
                if (linkChangesCounter_<xsl:value-of select="$uniqueId"/> > 0)
                {
                    // reload page to apply changes
                    linkChangesCounter_<xsl:value-of select="$uniqueId"/> = 0;
                    window.location.reload();
                }
            }
        </script>
    </xsl:template>
    
    
    <!-- The dialog and the form when clicking the button -->
    <xsl:template name="configure-links-dialog"> 
        <xsl:param name="links"/>
        <xsl:param name="uniqueId" select="$uniqueId"/>
        <xsl:param name="savingId" select="@zoneItemId"/>
        
        <div class="overlay" onclick="closeModalOutils_{$uniqueId}()"></div>
            
        <div class="ametys-cms-service ametys-zone-modal-settings" style="min-width: 500px;">
            <i class="fas fa-times close" onclick="closeModalOutils_{$uniqueId}()"></i>
            <div class="top">
               <div  class="title"><h3 class="service-title"><i18n:text i18n:key="LINK_DIRECTORY_CONFIG" i18n:catalogue="skin.{$skin}"/></h3></div>
            </div>
            
            <xsl:call-template name="configure-links-internal">
                <xsl:with-param name="links" select="$links"/>
                <xsl:with-param name="savingId" select="$savingId"/>
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
                <xsl:with-param name="class" select="'favourites'"/>
            </xsl:call-template>
		</div>
    </xsl:template>
    
    <xsl:template name="configure-links-internal"> 
         <xsl:param name="title"/>
         <xsl:param name="links"/>
         <xsl:param name="class"/>
         <xsl:param name="uniqueId" select="$uniqueId"/>
         <xsl:param name="savingId" select="@zoneItemId"/>
         <xsl:param name="configurable" select="$configurable"/>
         <xsl:param name="display-user-links" select="$display-user-links"/>
         <xsl:param name="userLinksThemeId" select="@custom-theme"/>
        
         <xsl:if test="$links">
             <div class="{$class}">
                  <xsl:if test="$title">
        	          <div class="title">
        	              <span><xsl:copy-of select="$title"/></span>
        	          
        	              <!-- Configure button -->
        	              <xsl:call-template name="user-links-configure">
        	                 <xsl:with-param name="uniqueId" select="$uniqueId"/>
                             <xsl:with-param name="configurable" select="$configurable"/>
                             <xsl:with-param name="display-user-links" select="$display-user-links"/>
        	              </xsl:call-template>
        	         </div>
                 </xsl:if>
    	          
    	         <div class="ametys-tools" id="tool-ametys_{$uniqueId}">
    	              <input data-edit-mode-toggle="" type="checkbox" id="tool-toggle-ametys_{$uniqueId}" class="ametys-toggle__check ametys-edit-mode-checker" style="display: none;"/>
    	              
                      <div class="">
    	                  <p data-no-items-text="" class="ametys-tools-no-items-text"><i18n:text i18n:key="LINK_DIRECTORY_NO_TOOLS" i18n:catalogue="skin.{$skin}"/></p>
    	                   
                          <!-- Selected links -->
    	                  <div id="selected-links-ametys_{$uniqueId}" data-list-wrap="" class="ametys-tools-list-wrap ametys-animated-heigth">
    	                      <ul data-list="" class="ametys-tools-list ametys-tools-list_editable">
    	                         <xsl:for-each select="$links[@isHidden = 'false']">
    	                              <xsl:sort select="@user-selected" order="descending"/>
    	                              <xsl:apply-templates select="." mode="config"/>
    	                          </xsl:for-each>
    	                      </ul>
    	                  </div>
    	              </div>
    	              
                      <!-- Unselected links -->
    	              <xsl:call-template name="extra-links">
                          <xsl:with-param name="links" select="$links"/>
                          <xsl:with-param name="uniqueId" select="$uniqueId"/>
                          <xsl:with-param name="configurable" select="$configurable"/>
                          <xsl:with-param name="display-user-links" select="$display-user-links"/>
    	              </xsl:call-template>
    	          
                      <!-- Modal (delete, confirm) -->
    	              <xsl:call-template name="user-links-modals">
                          <xsl:with-param name="uniqueId" select="$uniqueId"/>
                      </xsl:call-template>
    	         </div>
    	         
    	         <xsl:call-template name="app-js">
                    <xsl:with-param name="savingId" select="$savingId"/>
                    <xsl:with-param name="uniqueId" select="$uniqueId"/>
                    <xsl:with-param name="userLinksThemeId" select="$userLinksThemeId"/>
    	         </xsl:call-template>
    	      </div>
          </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-links-modals">
        <xsl:param name="uniqueId" select="$uniqueId"/>
        
        <!-- Delete confirm -->
        <div id="data-delete-modal-ametys_{$uniqueId}" class="modal-confirm" style="display: none;"
            data-delete-modal="">
            <h4 class=""><i18n:text i18n:key="SKIN_USER_MENU_DELETE_CONFIRM" i18n:catalogue="skin.{$skin}"/></h4>

            <div class="">
                <span class="btn full" data-delete-modal-confirm=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_YES" i18n:catalogue="skin.{$skin}"/></span></span>
                <span class="btn" data-delete-modal-close=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_NO" i18n:catalogue="skin.{$skin}"/></span></span>
            </div>
        </div>
    
        <!-- Deactivate confirm -->
        <div id="data-deactivate-modal-ametys_{$uniqueId}" class="modal-confirm"
            style="display: none;" data-deactivate-modal="">
            <h4 class=""><i18n:text i18n:key="SKIN_USER_MENU_DEACTIVATE_CONFIRM" i18n:catalogue="skin.{$skin}"/></h4>

            <div class="">
                <span class="btn full"
                    data-deactivate-modal-confirm="ametys_{$uniqueId}"><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_YES" i18n:catalogue="skin.{$skin}"/></span></span>
                <span class="btn" data-deactivate-modal-close=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_NO" i18n:catalogue="skin.{$skin}"/></span></span>
            </div>
        </div>
    </xsl:template>
    
     <xsl:template name="extra-links">
        <xsl:param name="links"/>
        <xsl:param name="uniqueId" select="$uniqueId"/>
        <xsl:param name="configurable" select="$configurable"/>
        <xsl:param name="display-user-links" select="$display-user-links"/>
        
        <div id="unselected-links-ametys_{$uniqueId}" data-extra-list-wrap="" class="ametys-add-new-item" style="display: none;">
            <xsl:if test="$configurable = 'true'">
                <div class="flex-search-list">
                    <h3 class="ametys-add-new-item__title"><i18n:text i18n:key="LINK_DIRECTORY_CONFIGURE_LINKS_ADD_TITLE" i18n:catalogue="skin.{$skin}"/></h3>
                </div>
                <div data-extra-list-scroll="" class="ametys-tools-list-scroll">
                    <ul data-extra-list="" class="ametys-tools-list ametys-tools-list-inline">
                        <xsl:apply-templates select="$links[@isHidden = 'true']" mode="config"/>
                    </ul>
                </div>
            </xsl:if>
            
            <!-- Add form -->
            <xsl:call-template name="add-user-link-form">
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
                <xsl:with-param name="display-user-links" select="$display-user-links"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="add-user-link-form">
        <xsl:param name="uniqueId" select="$uniqueId"/>
        <xsl:param name="display-user-links" select="$display-user-links"/>
        
        <xsl:if test="$display-user-links = 'true'">
            <div id="data-add-new-item-form-ametys_{$uniqueId}" class="ametys-add-new-item"
                style="display: none;" data-add-new-item-wrap="">
                <form action="" data-add-new-item-form="">
                    <h3 class="ametys-add-new-item__title"><i18n:text i18n:key="LINK_DIRECTORY_ADD_USER_LINKS" i18n:catalogue="skin.{$skin}"/></h3>
    
                    <div class="ametys-field-group">
    
                        <input id="mesOutilsItemUrl" placeholder="skin.{$skin}:LINK_DIRECTORY_URL_LABEL" i18n:attr="placeholder"
                            class="ametys-field-group__control" name="mesOutilsItemUrl" type="text"
                            data-add-new-item-field-url="" />
                    </div>
                    <div class="ametys-field-group">
    
                        <input id="mesOutilsItemTitle" placeholder="skin.{$skin}:LINK_DIRECTORY_TITLE_LABEL" i18n:attr="placeholder"
                            class="ametys-field-group__control" name="mesOutilsItemTitle" type="text"
                            data-add-new-item-field-title="" />
                    </div>
    
                    <div class="text-right">
                        <input id="linkId" name="linkId" type="hidden" />
                        <input id="favicon" name="favicon" type="hidden" />
                        <button class="btn" type="submit" disabled="" data-add-new-item-field-submit="">
                            <i18n:text i18n:key="LINK_DIRECTORY_ADD" i18n:catalogue="skin.{$skin}"/>
                        </button>
                    </div>
    
                </form>
            </div>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template match="link" mode="config">
       <li class="ametys-tools-list__item" data-list-item="">
           <xsl:if test="@userLink = 'true'">
               <xsl:attribute name="data-app-type">custom</xsl:attribute>
           </xsl:if>
           <span class="material-icons ametys-tools-list__action">
                close
            </span>
            
            <a data-list-link="" target="_blank" class="ametys-tools-list__link" data-serverid="{@id}" title="{@alternative}">
                <xsl:attribute name="href">
                    <xsl:choose>
                        <xsl:when test="@urlType = 'PAGE'">
                            <xsl:value-of select="resolver:resolve('page', @url)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="@url"/>
                        </xsl:otherwise>
                    </xsl:choose>
              </xsl:attribute>
              
              <xsl:apply-templates select="." mode="app-icon"/>
                                              
              <span class="ametys-tools-list__title">
                <xsl:value-of select="@title"/>
               </span>
             </a>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="app-icon">
        <div class="icon">
            <xsl:choose>
                <xsl:when test="@pictureType = 'glyph'">
                    <i class="picture link-glyph {@pictureGlyph}"></i>
                </xsl:when>
                <xsl:when test="@pictureType != ''">
                    <xsl:variable name="id">
                        <xsl:choose>
                            <xsl:when test="@pictureType = 'resource'">
                                <xsl:value-of select="@pictureId"/>
                            </xsl:when>
                            <xsl:when test="@pictureType = 'external'">
                                <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:variable>
            
                    <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 30, 30)}" alt="{@pictureAlternative}"/>
                </xsl:when>
                <xsl:otherwise>
                    <span>
                        <xsl:value-of select="substring(@title, 0, 3)"/>
                    </span>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="@status = 'NEW'">
                <span class="ametys-tools-list__new"><i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LINK_DIALOG_STATUS_NEW_LABEL" i18n:catalogue="plugin.link-directory"/></span>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="user-links-configure">
        <xsl:param name="configurable" select="$configurable"/>
        <xsl:param name="display-user-links" select="$display-user-links"/>
        <xsl:param name="uniqueId"/>
        
        <!-- Configure button -->
        <xsl:if test="$display-user-links = 'true' or $configurable = 'true'">
            <a href="#" onclick="toggleCheckbox_ametys_{$uniqueId}(this)">
                <span><i18n:text i18n:key="LINK_DIRECTORY_CONFIGURE" i18n:catalogue="skin.{$skin}"/></span>
                <i class="fa fa-cog"></i>
            </a>
        </xsl:if>
        
        <script type="text/javascript">
            function toggleCheckbox_ametys_<xsl:value-of select="$uniqueId"/>(el) {
                 $j("#tool-toggle-ametys_<xsl:value-of select="$uniqueId"/>").trigger('click');
                 $j(el).toggleClass('active');
    
                 if ($j(el).hasClass('active')) {
                     $j(el).find('span').html("<i18n:text i18n:key="LINK_DIRECTORY_CLOSE" i18n:catalogue="skin.{$skin}"/>");
    
                     $j(".ametys-tools-list__link")
                         .each(function () {
                             $j(this).attr('data-href', $j(this).attr('href'));
                             $j(this).attr('href', 'javascript:void(0)');
                             $j(this).removeAttr('target');
                         });
                 } else {
                     $j(el).find('span').html("<i18n:text i18n:key="LINK_DIRECTORY_CONFIGURE" i18n:catalogue="skin.{$skin}"/>");
                     $j(".ametys-tools-list__link")
                         .each(function () {
                             $j(this).attr('href', $j(this).attr('data-href'));
                             $j(this).attr('target', '_blank');
                         });
                         
                    // reset counter
                    linkChangesCounter_<xsl:value-of select="$uniqueId"/> = 0;
                 }
             }
        </script>
    </xsl:template>
    
    <xsl:template name="app-js">
        <xsl:param name="savingId"/>
        <xsl:param name="uniqueId"/>
        <xsl:param name="userLinksThemeId"/>
        
        <script type="text/javascript">
            var linkChangesCounter_<xsl:value-of select="$uniqueId"/> = 0;
            
            function deactivateLink_ametys_<xsl:value-of select="$uniqueId"/>(event, target) {
                saveUserPrefs_ametys_<xsl:value-of select="$uniqueId"/>();
            };
            
           function getSelectedLinks_ametys_<xsl:value-of select="$uniqueId"/>() {
               var orderedItems = $j("#selected-links-ametys_<xsl:value-of select="$uniqueId"/> li").map(function () {
                   var $this = $j(this);
                   return {
                       offset: $this.offset(),
                       servid: $this.find("a[data-serverid]").attr("data-serverid")
                   };
               }).get();
    
               orderedItems.sort(function (a, b) {
                   if (a.offset.top != b.offset.top) {
                       return a.offset.top - b.offset.top;
                   } else {
                       return a.offset.left - b.offset.left;
                   }
               });
               var orderedItemsIds = [];
               for (var i in orderedItems) {
                   orderedItemsIds.push(orderedItems[i].servid);
               }
    
               return orderedItemsIds;
           }
    
           function getHiddenLinks_ametys_<xsl:value-of select="$uniqueId"/>() {
               return $j("#unselected-links-ametys_<xsl:value-of select="$uniqueId"/> li>a[data-serverid]").map(function () {
                   return $j(this).attr("data-serverid");
               }).get();
           }
    
           var orderedItemIds_ametys_<xsl:value-of select="$uniqueId"/> = getSelectedLinks_ametys_<xsl:value-of select="$uniqueId"/>();
           var hiddenItemIds_ametys_<xsl:value-of select="$uniqueId"/> = getHiddenLinks_ametys_<xsl:value-of select="$uniqueId"/>();
    
           function saveUserPrefs_ametys_<xsl:value-of select="$uniqueId"/>() {
               var orderedItemsIds = getSelectedLinks_ametys_<xsl:value-of select="$uniqueId"/>();
    
               var hidden = getHiddenLinks_ametys_<xsl:value-of select="$uniqueId"/>();
    
               if (orderedItemsIds.toString() != orderedItemIds_ametys_<xsl:value-of select="$uniqueId"/>.toString() || hidden
                   .toString() != hiddenItemIds_ametys_<xsl:value-of select="$uniqueId"/>.toString()) {
                   orderedItemIds_ametys_<xsl:value-of select="$uniqueId"/> = orderedItemsIds;
                   hiddenItemIds_ametys_<xsl:value-of select="$uniqueId"/> = hidden;
    
                   var siteUriPrefix = '<xsl:value-of select="ametys:siteUriPrefix()" />';
                   var savingId = '<xsl:value-of select="$savingId" />';
                   var lang = '<xsl:value-of select="ametys:lang()"/>';
                   AmetysHelperLinkDirectory.saveUserPrefs(orderedItemsIds, hidden, siteUriPrefix, lang, savingId, null, null);
                   
                   linkChangesCounter_<xsl:value-of select="$uniqueId"/>++;
               }
           }
    
           function addUserLink_ametys_<xsl:value-of select="$uniqueId"/>(title, url, color) {
               $j.ajax({
                    url: '<xsl:value-of select="ametys:siteUriPrefix()"/>/_plugins/link-directory/add-user-link',
                    data: {
                        siteName: "<xsl:value-of select="ametys:site()"/>",
                        lang: "<xsl:value-of select="ametys:lang()"/>",
                        title: title,
                        url: url,
                        color: color,
                        themes: "<xsl:value-of select="$userLinksThemeId" />"
                    },
                    method: 'POST',
                    success: addUserLinkCb_ametys_<xsl:value-of select="$uniqueId"/>,
                    error: function(data) {alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_ADD_USER_LINK_DIALOG_ERROR" i18n:catalogue="plugin.link-directory"/>");}
                });
           };
    
           function addUserLinkCb_ametys_<xsl:value-of select="$uniqueId"/>(data) {
               var result = JSON.parse(data);
               var error = result.error;
    
               switch (error) {
                   case "none":
                       $j(".ametys-tools .ametys-tools-list__item a[data-href='" + result.url + "'] .icon i").remove();
                        if (result.picture.viewUrl)
                        {
                            $j(".ametys-tools .ametys-tools-list__item a[data-href='" + result.url + "'] .icon").prepend("&lt;img src=\"" + result.picture.viewUrl + "\"/&gt;");
                        }
                        else
                        {
                            // default icon
                            $j(".ametys-tools .ametys-tools-list__item a[data-href='" + result.url + "'] .icon").prepend("&lt;span&gt;" + result.title.substring(0, 2) + "&lt;/span&gt;");
                        }
                        
                       //var form = $j(
                       //   "#data-add-new-item-form-ametys_<xsl:value-of select="$uniqueId"/> [data-add-new-item-form]");
                       //form.find("input[name='linkId']").val(result.id);
                       //form.find("input[name='linkId']").trigger("change");
                       //form.find("input[name='favicon']").val(result.picture.viewUrl);
                       //form.find("input[name='favicon']").trigger("change");
                       //form.submit();
                       
                       linkChangesCounter_<xsl:value-of select="$uniqueId"/>++;
    
                       break;
                   case "already-exists":
                       alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LINK_ERROR_ALREADY_EXISTS" i18n:catalogue="plugin.link-directory"/>");
                       break;
                   default:
                       alert("<i18n:text i18n:key="PLUGINS_LINKDIRECTORY_LINK_ERROR_CREATE" i18n:catalogue="plugin.link-directory"/>");
               }
               
               
           }
    
           function deleteLink_ametys_<xsl:value-of select="$uniqueId"/>(event, target) {
               var linkId = $j(target).find("a[data-serverid]").attr("data-serverid");
               if (linkId != null &amp;&amp; linkId != "")
               {
                   AmetysHelperLinkDirectory.removeUserLinks([linkId], "<xsl:value-of select="ametys:siteUriPrefix()"/>", null, null, null);
                   linkChangesCounter_<xsl:value-of select="$uniqueId"/>++;
               }
               
           };
           
           function deactivateLink_ametys_<xsl:value-of select="$uniqueId"/>(event, target) {
               saveUserPrefs_ametys_<xsl:value-of select="$uniqueId"/>();
           };
    
           function activateLink_ametys_<xsl:value-of select="$uniqueId"/>(event, target) {
               saveUserPrefs_ametys_<xsl:value-of select="$uniqueId"/>();
           };
    
           function moveLink_ametys_<xsl:value-of select="$uniqueId"/>(event, target) {
               saveUserPrefs_ametys_<xsl:value-of select="$uniqueId"/>();
           };
    
           $j('#data-add-new-item-form-ametys_<xsl:value-of select="$uniqueId"/> button[data-add-new-item-field-submit]').on(
               'click',
               function (event) {
               var form = $j(
                   "#data-add-new-item-form-ametys_<xsl:value-of select="$uniqueId"/> [data-add-new-item-form]");
               form.find("input[name='linkId']").val(""); //reset the ID
               form.find("input[name='favicon']").val(""); //reset the favicon


               var href = form.find("input[data-add-new-item-field-url]").val();
               var title = form.find("input[data-add-new-item-field-title]").val();
               var color = form.find("input:checked[data-add-new-item-field-color]").attr(
                   "data-color-id");
               addUserLink_ametys_<xsl:value-of select="$uniqueId"/>(title, href, color);
               
               linkChangesCounter_<xsl:value-of select="$uniqueId"/>++;
               event.preventDefault();
               return false;
           });
       </script>
    </xsl:template>
</xsl:stylesheet>

    