<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exsl="http://exslt.org/common"
                extension-element-prefixes="math resolver ametys">
    
   <xsl:import href="plugin:link-directory://pages/services/directory/utils/thumbnails_utils.xsl"/>
   
   <xsl:template name="link-picture">
        <xsl:param name="height"/>
        <xsl:param name="width"/>
        
        <xsl:if test="@pictureType != ''">
            <xsl:choose>
                <xsl:when test="@pictureType = 'glyph'">
                    <span class="picture link-glyph {@pictureGlyph}" style="font-size: {$height}px; color:{@color}"></span>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="id">
                        <xsl:choose>
                            <xsl:when test="@pictureType = 'resource'">
                                <xsl:value-of select="@pictureId"/>
                            </xsl:when>
                            <xsl:when test="@pictureType = 'external'">
                                <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:variable>
            
                    <span class="picture">
                        <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, $height, $width)}" alt="{@pictureAlternative}"/>
                    </span>
                </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>