<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
                
    <xsl:import href="plugin:ugc://pages/services/ugc/form.xsl"/>
    
    <!-- Used by common -->
	<xsl:template name="common-service-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/ressource_file.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
	</xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            $j(document).ready(function() {
                var $input = $j('.ugc form .field input');
                $input.each(function() {
                    var $this = $j(this),
                        $label = $this.closest('.field').find('.label'),
                        label = $label.find('label').text();
                        
                    $this.attr('placeholder', label);
                    $label.hide();
                })
                
                var $textarea = $j('.ugc form .field textarea');
                $textarea.each(function() {
                    var $this = $j(this),
                        $label = $this.closest('.field').find('.label'),
                        label = $label.find('label').text();
                        
                    $this.attr('placeholder', label);
                    $label.hide();
                })
                
                var $category = $j("select[name='category']");
                $category.closest('.field').find('.label').hide();
                var opt = $category.find("option[value='']");
                opt.text("- <i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_CATEGORY" i18n:catalogue="plugin.classified-ads"/> -");
            });
        </script>
        
        <xsl:call-template name="contenttype-form-header">
            <xsl:with-param name="view" select="/ugc/mixin/view|/ugc/content-type/view"/>
        </xsl:call-template>
        
    </xsl:template>

</xsl:stylesheet>