<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math"
                exclude-result-prefixes="resolver math">

	<xsl:import href="plugin:web://pages/services/filtered-pages/list_3.5.xsl"/>	
	
	<xsl:variable name="common-service-css-class-name"> filtered-pages ametys-zone-actu ametys-zone-search</xsl:variable>
    
<!-- Used by common -->
	<xsl:template name="common-service-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/static_service_filtered_pages.css')}" />
	</xsl:template>
	
	<xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <div class="flex-title">
            	<xsl:call-template name="common-service-body-nonempty-content-title"/>
            	<xsl:call-template name="link"/>
            </div>
            
            <xsl:call-template name="common-service-body-nonempty-content-content"/>            
        </div>
    </xsl:template>
	
	<xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="link-top"/>
        
        <xsl:call-template name="js-pagination-part"/>
        
        <xsl:call-template name="js-pagination-top"/>
        
        <div>
        	<xsl:call-template name="pages"/>
        </div>

        <xsl:call-template name="js-pagination-bottom"/>
        
        <xsl:call-template name="link-bottom"/>
    </xsl:template>
    
    <!-- Template for div pages + pagination -->
	<xsl:template name="pages">
		<xsl:param name="from" select="0"/>
		<xsl:param name="by" select="$pagesPerPage"/>
		<xsl:param name="count" select="1"/>
	
		<div id="{$prefix}-part-{$count}" class="tribu">
			<script type="text/javascript">
				<xsl:comment>
					<xsl:if test="$count &gt; 1">
						document.getElementById('<xsl:value-of select="$prefix"/>-part-<xsl:value-of select="$count"/>').style.display = 'none';
					</xsl:if>
						
					pagination_<xsl:value-of select="$prefix"/>.push('<xsl:value-of select="$count"/>');
				</xsl:comment>
			</script>

			<ul class="disc">			
				<xsl:apply-templates select="/pages/page[position() &gt;= ($from + 1) and position() &lt; ($by + $from + 1)]"/>
			</ul>
            <div class="clear-L"><xsl:comment>empty</xsl:comment></div>
		</div>
		
		<xsl:if test="$from + $by &lt; count(page)">
				<xsl:call-template name="pages">
					<xsl:with-param name="from" select="$from + $by"/>
					<xsl:with-param name="by" select="$by"/>
					<xsl:with-param name="count" select="$count + 1"/>
				</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!-- Template for a page -->
	<xsl:template match="page">
		<li>
            <a href="{resolver:resolve('page', @id, false)}">
            	<i style="font-size: small;" class="fas fa-circle"></i>
            	<xsl:value-of select="@title"/>
            </a>
		</li>
	</xsl:template>
	
	<xsl:template name="link-top"/>
	<xsl:template name="link-bottom"/>
    
</xsl:stylesheet>
