<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:template name="pagination">
        <form id="reload">
            <div class="button-container">
                <nav class="pagination">
                    <xsl:apply-templates select="ametys:pagination(/search/pagination/@total + 0, /search/pagination/@current + 0, 0, 10, 0)" mode="search-pagination">
                        <xsl:with-param name="original-context-node" select="/"/>
                    </xsl:apply-templates>
                </nav>
            </div>
        </form>
    </xsl:template>
    
    <xsl:template match="gotofirstpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <a href="#" class="arrow arrow-left">
                <xsl:attribute name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="page" select="."/>
                    </xsl:call-template>
                </xsl:attribute>
                <i class="fas fa-angle-double-left"></i>
            </a>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template match="gotopreviouspage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <a href="#" class="arrow arrow-left">
                <xsl:attribute name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="page" select="."/>
                    </xsl:call-template>
                </xsl:attribute>
                <i class="fas fa-angle-left"></i>                     
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <a href="#" class="page-link">
            <xsl:attribute name="onclick">
                <xsl:call-template name="search-js-page">
                    <xsl:with-param name="original-context-node" select="$original-context-node"/>
                    <xsl:with-param name="page" select="."/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:value-of select="."/>
        </a>
    </xsl:template>
    
    <xsl:template match="current" mode="search-pagination">
        <a href="#" class="page-link active"><xsl:value-of select="."/></a>
    </xsl:template>
    
    <xsl:template match="gotonextpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <a href="#" class="arrow arrow-right">
                <xsl:attribute name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="page" select="."/>
                    </xsl:call-template>
                </xsl:attribute>
                <i class="fas fa-angle-right"></i>
            </a>
        </xsl:if>
    </xsl:template>
    <xsl:template match="gotolastpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled='true'">
            <a href="#" class="arrow arrow-right">
                <xsl:attribute name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="page" select="."/>
                    </xsl:call-template>
                </xsl:attribute>
                <i class="fas fa-angle-double-right"></i>
            </a>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="pagination-more-results">
        <xsl:if test="/search/pagination/@total > 1">
            <div data-ametys-search-role="show-more" class="button-container">
                <button class="button">
                    <xsl:attribute name="onclick"><xsl:call-template name="search-js-next-page"/></xsl:attribute>
                    <i18n:text i18n:key="SKIN_SERVICE_SEARCH_SHOW_MORE_BTN" i18n:catalogue="skin.{$skin}"/>
                </button>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
