<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
        
    <xsl:template name="search-results-children">
        <xsl:call-template name="form-criteria-hidden"/>
        
        <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
            <xsl:call-template name="back-button"/>
        </xsl:if>
        
        <xsl:if test="$result-display-type = 'ABOVE_CRITERIA' or $result-display-type = 'IN_PLACE_OF_CRITERIA'" >
            <xsl:call-template name="form-result"/>
            <xsl:call-template name="form-result-js"/>
        </xsl:if>
        
        <xsl:choose>
            <xsl:when test="/search/hits/hit">
                <xsl:call-template name="facet-filter"/>
                
                <!-- Sort for mobile -->
                <xsl:call-template name="sorts">
                    <xsl:with-param name="mobile" select="true()"/>
                </xsl:call-template>
                
                
                <xsl:call-template name="hits"/>
                <xsl:call-template name="pagination"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="/search/hits">
                    <!-- hits is present but no single hit => there is no result -->
                    <xsl:call-template name="no-result"/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="search-results">
        <xsl:call-template name="anchor" />
        
        <div class="search-results" data-ametys-search-role="search-results">
            <xsl:call-template name="search-results-children"/>
        </div>
    </xsl:template>
    
    <xsl:template name="form-result">
        <xsl:if test="/search/hits/hit">
            <div class="results-header">
                <div class="results-header-title">
                    <xsl:call-template name="results-for"/>
                    <xsl:call-template name="rss"/>
                </div>
    
                <xsl:call-template name="sorts"/>
            </div>
        </xsl:if>
        
        <script type="text/javascript">
            $j(document).ready(function() {
                var headerHeight = $j('header').height();
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('display', 'block');
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('position', 'relative');
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('top', -headerHeight + 'px');
            });
        </script>
    </xsl:template>
    
    <xsl:template name="results-for">
        <xsl:variable name="textfield-criteria">
            <xsl:for-each select="/search/form/values/criterion[starts-with(@name, 'user.input.criterion.common$wording$textfield') or starts-with(@name, 'user.input.criterion.common$titleorwording$textfield')]">
                <xsl:value-of select="text()"/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="count" select="/search/hits/@total"/>
        
        <div class="nb-results">
            <xsl:choose>
                <xsl:when test="$count > 1 and $textfield-criteria != ''">
                    <i18n:translate>
                        <i18n:text i18n:key="SKIN_SERVICE_SEARCH_NB_RESULTS_FOR" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param name="count"><xsl:value-of select="$count"/></i18n:param>
                    </i18n:translate>
                    <strong><xsl:value-of select="stringutils:removeEnd($textfield-criteria, ',')"/></strong>
                </xsl:when>
                <xsl:when test="$textfield-criteria != ''">
                    <i18n:translate>
                        <i18n:text i18n:key="SKIN_SERVICE_SEARCH_NB_RESULT_FOR" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param name="count"><xsl:value-of select="$count"/></i18n:param>
                    </i18n:translate>
                    <strong><xsl:value-of select="stringutils:removeEnd($textfield-criteria, ',')"/></strong>
                </xsl:when>
                <xsl:when test="$count > 1">
                    <i18n:translate>
                        <i18n:text i18n:key="SKIN_SERVICE_SEARCH_NB_RESULTS" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param name="count"><xsl:value-of select="$count"/></i18n:param>
                    </i18n:translate>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:translate>
                        <i18n:text i18n:key="SKIN_SERVICE_SEARCH_NB_RESULT" i18n:catalogue="skin.{$skin}"/>
                        <i18n:param name="count"><xsl:value-of select="$count"/></i18n:param>
                    </i18n:translate>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
</xsl:stylesheet>