<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name"> ametys-zone-directory </xsl:variable>        
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="header"/>
            
            <xsl:call-template name="form-criteria"/>
            
            <xsl:call-template name="search-results"/>
        </div>
    </xsl:template>
    
    <xsl:template name="header">
        <div class="flex-right">
            <h1 class="service-title"><xsl:value-of select="$header"/></h1>
            <div>
                <xsl:call-template name="publish-ads"/> 
                <xsl:call-template name="link"/> 
            </div>
        </div>
   </xsl:template> 
   
    <xsl:template name="publish-ads">
        <xsl:variable name="postPage" select="ametys:findPagesIdsByTag('ADD_ANNONCE')"/>
        <xsl:if test="$postPage and $template = 'index'">
           <a href="{resolver:resolve('page', $postPage/@id)}" class="btn btn--reverse">
	           <i class="fas fa-pencil-alt" aria-hidden="true"></i>
	           <i18n:text i18n:key="SKIN_BO_TAG_ADD_ANNONCE_LABEL" i18n:catalogue="skin.{$skin}"/>
	       </a>
       </xsl:if>
    </xsl:template>
    
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <xsl:call-template name="link-attribute"/>
                <i class="fas fa-arrow-right" aria-hidden="true"></i>
                <xsl:call-template name="link-title"/>
            </a>
        </xsl:if>
    </xsl:template>
   
    <xsl:template name="hits">
       	<div class="directory-list" data-ametys-search-role="hits">
       		<xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="/search/hits">
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
       	</div>	
    </xsl:template> 
    
    <xsl:template name="hit">
		<div>
        	<xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>directory-list-item<xsl:text> </xsl:text>
    </xsl:template> 
    
    <!-- Override: no form criteria available for this view (but needed for html structure validation) -->
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form style="display: none" method="post" class="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
        </form> 
    </xsl:template>
    
    <!-- Override : no pagination available for this view -->
    <xsl:template name="pagination"/>  
    
    <!-- Override to remove results title and anchor -->
    <xsl:template name="form-result"/>
    
</xsl:stylesheet>

