<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <!-- Force result display to 'above criteria' -->
    <xsl:variable name="result-display-type">ABOVE_CRITERIA</xsl:variable>
    
    <xsl:variable name="useMultipleFilter" select="ametys:serviceViewParameter('multipleFilter')" />
    
    <!-- Enable infinite loop on carousel -->
    <xsl:variable name="infiniteLoop">true</xsl:variable>
    
    <xsl:variable name="common-service-css-class-name">ametys-zone-home-actu <xsl:if test="$rendering-context = 'back'"> back</xsl:if></xsl:variable>

    <xsl:variable name="callback-function">callbackForm</xsl:variable>
        
    <xsl:template name="common-service-head-css">
    	<link media="screen, print" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/static_service_card_actu.css')}" type="text/css" />

        <!-- BEGIN head-css-owl-carousel -->
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel.min.css')}" type="text/css" />
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel-defaut-theme.min.css')}" type="text/css" />
	    <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />
    	<!-- END head-css-owl-carousel -->
	</xsl:template>
    
    <xsl:template name="common-service-head-js">
         <xsl:call-template name="search-service-head-js"/>
         
		<script type="text/javascript" src="{ametys:skinURL('plugins/js/owl-carousel.min.js')}"></script>
		<script type="text/javascript">
            function loadOwlCarousel_<xsl:value-of select="$uniqueId"/>()
            {
                $j('.ametys-zone-home-actu .owl-carousel').owlCarousel({
                    loop: <xsl:value-of select="$infiniteLoop"/>,
                    margin: 12,
                    dots: false,
                    autoWidth: true,
                    nav: true,
                    navText: [`&lt;a href="javascript:void(0)" class="arrow-left">
                        &lt;i class="fas fa-arrow-left">&lt;/i>
                    &lt;/a>`, `&lt;a href="javascript:void(0)" class="arrow-right">
                        &lt;i class="fas fa-arrow-right">&lt;/i>
                    &lt;/a>
                    `],
                    responsive: {
                                0: {
                                    items: 1,
                                    slideBy: 1,
                                },
                                550: {
                                    items: 2,
                                    slideBy: 1
                                },
                                850: {
                                    items: 3,
                                    slideBy: 1
                                },
                                1400: {
                                    items: 4,
                                    slideBy: 1
                                }
                            },
                    slideBy: 1
                });
            }
            
			$j(document).ready(function(){
				$j('#search-form-<xsl:value-of select="$uniqueId"/> .select-association').on('change', function() {
	                 $j("#search-form-<xsl:value-of select="$uniqueId"/> button[data-search]").click()
	            });

                loadOwlCarousel_<xsl:value-of select="$uniqueId"/>();
			})
			
			function callbackForm()
			{
				loadOwlCarousel_<xsl:value-of select="$uniqueId"/>();
			}
			
            <xsl:call-template name="custom-filter-js"/>
		</script>
	</xsl:template>

    <!-- JS for custom filter dropdown -->    
    <xsl:template name="custom-filter-js">
        <xsl:if test="$useMultipleFilter = 'true'">
              function openDropdownPersonnalize() {
                $j('.dropdown-personnalize').show();
                $j('.ametys-zone-home-actu .btn').css('z-index', 'initial')
              }
    
              function closeDropdownPersonnalize() {
                $j('.dropdown-personnalize').hide();
                $j('.ametys-zone-home-actu .btn').css('z-index', '10')
              }
    
              setTimeout(function () {
                document
                    .querySelector(".dropdown-personnalize")
                    .addEventListener("click", function getDetails(evt) {
                        evt.stopPropagation();
                    });
    
                document
                    .querySelector(".personnalize-link")
                    .addEventListener("click", function getDetails(evt) {
                        evt.stopPropagation();
                    });
    
    
                document.addEventListener("click", function (e) {
                    closeDropdownPersonnalize();
                });
              }, 500);
            </xsl:if>
    </xsl:template>
	
    <xsl:template name="common-service-body-nonempty-content-title-rendering"/>
    
	<xsl:template name="header">
        <xsl:if test="$header != ''">        
    	   	<h1 class="service-title"><xsl:value-of select="$header"/></h1>
        </xsl:if>
   </xsl:template>
    
    <!-- The service HTML structure when there is something in the service -->
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper ">
        	<div class="container">
                <xsl:call-template name="filter"/>
                
	            <xsl:call-template name="noscript"/>
                
                <xsl:call-template name="search-results"/>
	        </div>
	        
	        <xsl:call-template name="link"/> 
        </div>
    </xsl:template>
    
    <xsl:template name="filter">
        <div class="filter">
            <xsl:call-template name="header"/>
            
            <div class="flex">
                <form action="{$site-uri-prefix}/{/search/url}#{$anchor-id}" method="post" data-ametys-search-role="form" class="search" name="{$search-form-id}" id="{$search-form-id}">
                    <xsl:choose>
                    	<xsl:when test="not($useMultipleFilter) or $useMultipleFilter = 'false'">
                    		<xsl:call-template name="form-filter-single"/>
                    	</xsl:when>
                    	<xsl:otherwise>
                    		<xsl:call-template name="form-filter-multiple"/>
                    	</xsl:otherwise>
                    </xsl:choose>
                </form>
             </div>
        </div>
    </xsl:template>
    
    <xsl:template name="form-filter-single">
        <xsl:if test="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]">
            <div class="flex">
                <xsl:call-template name="filter-title"/>
                <xsl:apply-templates select="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="field">
                    <xsl:with-param name="value" select="/search/form/values/criterion[@name = /search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]/@name]"/>
                </xsl:apply-templates>
            </div>
            <button style="display: none !important;" data-search="true">
                <xsl:attribute name="onclick"><xsl:call-template name="search-js-submit-button"/></xsl:attribute>
            </button>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-filter-multiple">
		<xsl:if test="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]">
             <xsl:call-template name="form-filter-multiple-btn"/>
             
             <div class="dropdown-personnalize">
                <xsl:call-template name="criteria-dropdown-icon"/>
                <div class="dropdown-content">
                    <xsl:apply-templates select="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="multiple-field">
                        <xsl:with-param name="value" select="/search/form/values/criterion[@name = /search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]/@name]"/>
                    </xsl:apply-templates>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="filter-title">
        <span><i18n:text i18n:key="SKIN_SERVICE_SEARCH_VIEW_SHOW" i18n:catalogue="skin.{$skin}"/></span>
    </xsl:template>
    
    <xsl:template name="search-results">
        <div class="carousel-container" data-ametys-search-role="search-results">
            <xsl:call-template name="form-criteria-hidden"/>
            
            <xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:call-template name="hits"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="/search/hits">
                        <!-- hits is present but no single hit => there is no result -->
                        <xsl:call-template name="no-result"/>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="hits">
        <div data-ametys-search-role="hits" class="owl-carousel owl-theme">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
    </xsl:template> 
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
    </xsl:template> 
    
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-attribute">
        <xsl:attribute name="class">btn</xsl:attribute>
    </xsl:template> 
    
    <xsl:template name="link-title">
        <xsl:choose>
            <xsl:when test="normalize-space(/search/link/title) != ''">
            	<i class="fas fa-arrow-right" aria-hidden="true"></i>
                <xsl:value-of select="/search/link/title"/>
            </xsl:when>
            <xsl:otherwise>
            	<i class="fas fa-arrow-right" aria-hidden="true"></i>
    	        <xsl:call-template name="link-default-title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Override to add css class -->
    <xsl:template match="criterion[enumeration]" mode="field">
        <xsl:param name="value"/>
        
        <div class="field second select">
            <xsl:apply-templates select="." mode="field-label"/>
                
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <!-- Override to hide label -->
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <label for="{$id}" class="sr-only"><xsl:apply-templates select="." mode="field-label-text"/></label>
    </xsl:template>
    
    <!-- Override to add 'select-association' css class and caret icon -->
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        	
        <select id="{$id}" name="{@name}" class="select-association">
            <xsl:apply-templates select="." mode="criterion-enumeration-select"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-all-option"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-options">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </select>
        <i class="fas fa-caret-down" aria-hidden="true"></i>
    </xsl:template>
    
    <!-- FIXME: Override because computed count does not work with tags -->
    <xsl:template match="criterion[enumeration]" mode="criterion-enumeration-options">
        <xsl:param name="value"/>
        
        <xsl:for-each select="enumeration/item">
            <xsl:sort select="label" />
            
            <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', ../../@definition)"></xsl:value-of></xsl:variable>
            
            <xsl:variable name="itemValue">
                <xsl:choose>
                    <xsl:when test="contains($inputName, 'systemProperty$tags')">
                        <!--  Value is such as {"value":"TAG_NAME","autoposting":true} -->
                        <xsl:value-of select="substring-before(substring-after(@value, '{&quot;value&quot;:&quot;'), '&quot;,&quot;autoposting&quot;:true}')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="@value" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
            
            <xsl:if test="$compute-counts = 'false' or $count > 0">
                <option value="{@value}" data-value="{$value}" data-count="{$count}" data-inputname="{$inputName}">
                    <xsl:if test="@value = $value"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
                    <xsl:call-template name="criterion-item-label">
                       <xsl:with-param name="count" select="$count" />
                    </xsl:call-template>
                </option>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="criterion-enumeration-all-option">
        <option value="">
            <i18n:text i18n:key="SKIN_ALL_AGENDA" i18n:catalogue="skin.{$skin}"/>
        </option>
    </xsl:template>
    
    <!-- Multiple selection -->
    <xsl:template name="form-filter-multiple-btn">
        <a href="javascript:void(0)" onclick="openDropdownPersonnalize()" class="personnalize-link">
          <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="settings-icon"/>
            <i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_LINK" i18n:catalogue="skin.{$skin}"/>
        </a>
    </xsl:template>
    
    <xsl:template name="criteria-dropdown-icon">
        <div class="dropdown-icons">
            <xsl:call-template name="settings-icon"/>
            <i class="fa fa-times close" onclick="closeDropdownPersonnalize()" aria-hidden="true"></i>
        </div>
    </xsl:template>
    
    <xsl:template name="settings-icon">
        <svg width="18px" height="18px" viewBox="0 0 18 18" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
		    <title>E89A43EF-92AA-40EB-8F57-1D323F2C09F1</title>
		    <g id="Produit" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
		        <g id="Produit-news-medias" transform="translate(-124.000000, -198.000000)" fill="#795198" fill-rule="nonzero">
		            <g id="news" transform="translate(119.000000, 133.000000)">
		                <g id="btn-personnaliser" transform="translate(5.000000, 64.999820)">
		                    <g id="icon-settings" transform="translate(0.655450, 0.534949)">
		                        <path d="M16.4796792,10.8140773 L14.982006,9.94921501 C15.1331706,9.13361942 15.1331706,8.2968752 14.982006,7.48127961 L16.4796792,6.61641732 C16.6519238,6.51798692 16.7292743,6.31408803 16.6730381,6.12423099 C16.2827841,4.87268521 15.6183532,3.74064979 14.749989,2.79847141 C14.6164024,2.65431053 14.3984273,2.61915436 14.2296846,2.71761909 L12.7320113,3.58244705 C12.1027365,3.04102835 11.3784989,2.62269058 10.5945233,2.34847935 L10.5945233,0.622290987 C10.5945233,0.42543019 10.4574005,0.253151243 10.2640416,0.210956977 C8.97383775,-0.0772961202 7.6519453,-0.0632542531 6.4250157,0.210956977 C6.23165679,0.253151243 6.09453401,0.42543019 6.09453401,0.622290987 L6.09453401,2.35198123 C5.31406025,2.62972868 4.58985696,3.04806645 3.95704597,3.58594893 L2.46290891,2.72112097 C2.29062996,2.62269058 2.07619108,2.65431053 1.94260451,2.80197329 C1.07424034,3.74064979 0.40977507,4.87268521 0.0195553585,6.12776721 C-0.0402169905,6.31758991 0.0406353253,6.52148881 0.212914272,6.61995354 L1.71055322,7.48478149 C1.55938857,8.30041141 1.55938857,9.1371213 1.71055322,9.95275122 L0.212914272,10.8175792 C0.0406353253,10.9160096 -0.0367151068,11.1199428 0.0195553585,11.3097655 C0.40977507,12.5613456 1.07424034,13.6933467 1.94260451,14.6355594 C2.07619108,14.779686 2.29416618,14.8148421 2.46290891,14.7164117 L3.96054785,13.8515495 C4.58985696,14.3929681 5.31406025,14.8113403 6.09803589,15.0855515 L6.09803589,16.8152417 C6.09803589,17.0121025 6.23515867,17.1843815 6.42851759,17.2265414 C7.71875575,17.5148288 9.04061387,17.500787 10.2675778,17.2265414 C10.4609367,17.1843815 10.5980252,17.0121025 10.5980252,16.8152417 L10.5980252,15.0855515 C11.3784989,14.807804 12.1027365,14.3894663 12.7355475,13.8515495 L14.2331865,14.7164117 C14.4054654,14.8148421 14.6199043,14.7831879 14.7534909,14.6355594 C15.621855,13.6968829 16.2863203,12.5648475 16.67654,11.3097655 C16.7292743,11.1164066 16.6519238,10.9125077 16.4796792,10.8140773 Z M8.34452864,11.5277406 C6.79415545,11.5277406 5.53203535,10.2656205 5.53203535,8.71524731 C5.53203535,7.16487411 6.79415545,5.90275401 8.34452864,5.90275401 C9.89490184,5.90275401 11.1570219,7.16487411 11.1570219,8.71524731 C11.1570219,10.2656205 9.89490184,11.5277406 8.34452864,11.5277406 Z" id="Shape"></path>
		                    </g>
		                </g>
		            </g>
		        </g>
		    </g>
		</svg>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="multiple-field">
        <xsl:param name="value"/>
        
        <div class="list-checkbox">
            <xsl:apply-templates select="." mode="multiple-field-label"/>
            <xsl:apply-templates select="." mode="multiple-field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="multiple-field-label">
        <div class="dropdown-title"><i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_THEMATIQUES" i18n:catalogue="skin.{$skin}"/></div>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="multiple-field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="criterion-name" select="@name"/>
        
         <xsl:for-each select="enumeration/item">
            <xsl:sort select="label" />
            
            <div class="item-checkbox">
                 <xsl:variable name="id-checkbox"><xsl:call-template name="criterion-id"/></xsl:variable>
                 <xsl:variable name="onclick"><xsl:call-template name="search-js-submit-button"/></xsl:variable>
            
                <input onchange="{$onclick}" id="{$id-checkbox}-{position()}" type="checkbox" name="{$criterion-name}" value="{@value}">
                  <xsl:if test="$value = @value">
                        <xsl:attribute name="checked">checked</xsl:attribute>
                  </xsl:if>
                </input>
                    
               <label for="{$id-checkbox}-{position()}" class="checked">
                   <xsl:value-of select="label"/>
               </label>
            </div>
        </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>