<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:import href="skin://services/web/pages/services/search/default/criteria/criteria.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/criteria/rss.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/results/search-results.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/results/hits.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/results/pagination.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/results/facets.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/default/results/sorts.xsl"/>
    
    <xsl:variable name="callback-function">searchCallbackFunction</xsl:variable>
    
    <xsl:variable name="common-service-css-class-name">ametys-zone-search</xsl:variable>
    
    <!-- The number of dropdown items below which the search filter is hidden -->
    <xsl:variable name="configuredDropdownSearchFilterLimit" select="ametys:serviceViewParameter('dropdownSearchFilterLimit')"/>
    <xsl:variable name="dropdownSearchFilterLimit">
        <xsl:choose>
            <xsl:when test="$configuredDropdownSearchFilterLimit != ''"><xsl:value-of select="$configuredDropdownSearchFilterLimit"/></xsl:when>
            <xsl:otherwise>10</xsl:otherwise><!-- default value -->
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-service-head-css">
    	<link media="screen, print" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/static_service_search.css')}" type="text/css" />
	</xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
        
        <!-- TOOLTIP -->
        <script src="{ametys:skinURL('plugins/js/popper.min.js')}"></script>
        <script src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}"></script>
         
        <!-- Masonry grid -->
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/masonry.min.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/imagesloaded-5.0.0.js')}"></script>
        
         <script>
            // Callback function when searching
            function searchCallbackFunction()
            {
                // Add tooltip on tags if needed
                checkEtiquette();
                
                // Create tooltips
                tippy('[data-tippy-content]', {});
                
                // Filter input for facets' items
                $j(".field-dropdown-search input").on("keyup", filterFacets);
                
                // On select "all" option of a facet dropdown
                $j("input[data-unselected-all-facets]").change(function () {
                    onSelectAllFacet(this);
                });
                
                // Reload mansory grid
                refreshMasonryLayout();
            }
            
            // Open dropdown criteria
            function openDropdownThematique(input) {
              $j(input).next('.thematique-dropdown').toggle();
            }
            
            // On select "all" option in facets dropdown
            function onSelectAllFacet(allOptInput)
            {
                const $facetList = $j(allOptInput).closest('.field-dropdown-list');
                
                // Unselect all facet elements (except the first selected facet)
                const $selectedFacets = $facetList.find("input[data-ametys-search-role='facet-selected']");
                $selectedFacets.each(function(index) {
                    if (index != 0)
                    {
                        $(this).prop("checked", false);
                        $(this).attr("data-ametys-search-role", 'facet-unselected');
                    }
                })
                
                // Trigger click event on first selected facet element to launch search
                $facetList.find("input[data-ametys-search-role='facet-selected']").trigger("click");
            }
            
            // On select option in criteria dropdown
            function onSelectOptions(optInput)
            {
                const $dropdownList = $j(optInput).closest('.thematique-dropdown');
                const optValue = $j(optInput).val();
                const $input = $dropdownList.parent().find('.thematique');
                const $selectInput = $input.prev('select');
                const $allOpt = $dropdownList.find("input[value='']");
                
                if ($allOpt.is(":checked") 
                        &amp;&amp; $j(optInput).is(":checked") 
                        &amp;&amp; $j(optInput).attr("id") != $allOpt.attr("id")) 
                {
                    // unselect "all" option
                    $allOpt.prop("checked", false);
                }

                if ($allOpt.is(":checked")) 
                {
                    // unselect all other options if check "all" option
                    $dropdownList
                       .find("input[value!='']")
                       .prop("checked", false);
                    $input.val('');
                    $selectInput.val('');
                }
                else if ($dropdownList.find("input:checked").length == 0) 
                {
                    // no option selected => check 'all' option
                    $allOpt.prop("checked", true);
                    $input.val('');
                    $selectInput.val('');
                }
                else
                {
                    // get all checked inputs value and put it in the thematique input
                    var count = $dropdownList.find("input:checked").length;

                    var vals = [];
                    var labels = [];
                    $dropdownList.find("input:checked").each(function( index ) {
                      vals.push($j(this).val());
                      labels.push($j(this).next('label').text());
                    });

                    $input.val(labels.join(', '));
                    $selectInput.val(vals);
                }
            }
            
            // Filter on dropdown items
            function filterDropdownThematique()
            {   
                var value = $j(this).val().toLowerCase();
                $j(this)
                    .parent()
                    .parent()
                    .find(".thematique-dropdown-item")
                    .filter(function () {
                      $j(this).toggle(
                        $j(this).text().toLowerCase().indexOf(value) > -1
                      );
                    });
            }
            
            // Filter on facet items
            function filterFacets()
            {
                var value = $j(this).val().toLowerCase();
                $j(this)
                    .parent()
                    .parent()
                    .find(".field-dropdown-item")
                    .filter(function () {
                        $j(this).toggle(
                        $j(this).text().toLowerCase().indexOf(value) > -1
                    );
                });
            }
            
            // Refresh mansory layout
            function refreshMasonryLayout()
            {
                const $grids = $j('.search-container');
                
                // Use imagesloaded to avoid overlapping of grid elements (waiting for images loaded before refreshing masonry grid)
                $grids.imagesLoaded().always( function() {
                    $j('.search-container').masonry({
                        itemSelector: '.item',
                        gutter: 0
                    });
    
                    const $grids = $j('.search-container');
                    $grids.masonry('reloadItems');
                    $grids.masonry('layout');
                });
            }
            
            function checkEtiquette() {
                $j(".etiquette").each(function () {
                    if ($j(this)[0].offsetHeight + 10 &lt; $j(this)[0].scrollHeight) 
                    {
                        $j(this).attr("data-tippy-content", $j(this).text());
                    }
                });
            }
            
            $j(document).ready(function(){

                // Add tooltip on tags if needed
                checkEtiquette();
                
                // Tooltips
                tippy('[data-tippy-content]', {});
                
                
                // Close dropdown criteria
                $j(document).click(function (e) {
                    if (
                      $j(e.target).closest(".field-select").length === 0 &amp;&amp;
                      $j(e.target).closest(".thematique-dropdown").length === 0
                    ) {
                      $j(".thematique-dropdown").hide();
                    }
                });

                $j(".thematique-dropdown-item input").change(function () {
                    onSelectOptions(this);
                });
                
                // On select "all" option of a facet dropdown
                $j("input[data-unselected-all-facets]").change(function () {
                    onSelectAllFacet(this);
                });
                
                // Hide search filter for dropdown criteria of less than 10 items
                $j(".thematique-dropdown").each(function () {
                    let nbOpts = $j(this).find('.thematique-dropdown-item').length;
                    if (nbOpts &lt; <xsl:value-of select="$dropdownSearchFilterLimit"/>)
                    {
                        $j(this).find('.thematique-dropdown-search').hide();
                    }
                });
                
                // Filter input for dropdown criteria
                $j(".thematique-dropdown-search input").on("keyup", filterDropdownThematique);
                
                // Filter input for facets' items
                $j(".field-dropdown-search input").on("keyup", filterFacets);
                  
                // init mansory layout
                refreshMasonryLayout();
            });
        </script>
	</xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        
        <xsl:choose>
            <xsl:when test="/search/form/fields/criterion">
                <form method="post" class="search-bar" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
                    <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                        <xsl:attribute name="style">display: none;</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="$result-display-type = 'ON_PAGE'">
                        <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
                    </xsl:if>
                    
                    <xsl:call-template name="form-search"/>
                </form> 
            </xsl:when>
            <xsl:otherwise>
                <form method="post" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}" style="display: none">
                </form>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Overriden to add separator -->
    <xsl:template name="form-search">
        <xsl:for-each select="/search/form/fields/criterion">
            <xsl:apply-templates select="." mode="field">
                <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
            </xsl:apply-templates>
            
            <xsl:if test="position() != last()">
                <div class="separator"></div>
            </xsl:if>
        </xsl:for-each>
        
        <xsl:call-template name="submit-inputs"/>
    </xsl:template>
    
    <!-- Override search button -->
    <xsl:template name="submit-inputs-button">
        <div class="search-btn">
          <button type="submit" class="btn btn-primary">
            <xsl:attribute name="onclick"><xsl:call-template name="search-js-submit-button"/></xsl:attribute>
            <i18n:text i18n:key="PLUGINS_WEB_SERVICE_SEARCH_VIEW_BUTTON_OK" i18n:catalogue="plugin.web"/>
          </button>
        </div>
    </xsl:template>
    
    <xsl:template name="hit">
        <xsl:apply-templates select="."/>
    </xsl:template>
    
    <xsl:template name="hit-attributes"/>
    
</xsl:stylesheet>