<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">service-kiosque <xsl:if test="ametys:template() != 'index'">ametys-zone-kiosque </xsl:if></xsl:variable>        
    
    <xsl:template name="common-service-head-css">
        <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/static_service_kiosque.css')}" type="text/css" />
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <div class="container-kiosque">
                <xsl:call-template name="header"/>
                <xsl:call-template name="search-results"/>
            </div>
        </div>
    </xsl:template>
    
	<xsl:template name="header">
        <xsl:param name="title"/>
        
	   	<div class="flex-right">
	        <h1 class="service-title"><xsl:value-of select="$header"/></h1>
	        <xsl:call-template name="link"/>
        </div>
    </xsl:template>
   
    <xsl:template name="link-attribute">
        <xsl:attribute name="class">btn</xsl:attribute>
    </xsl:template> 
    
    <xsl:template name="link-title">
        <xsl:choose>
            <xsl:when test="normalize-space(/search/link/title) != ''">
            	<i class="fas fa-arrow-right" aria-hidden="true"></i>
                <xsl:value-of select="/search/link/title"/>
            </xsl:when>
            <xsl:otherwise>
            	<i class="fas fa-arrow-right" aria-hidden="true"></i>
    	        <xsl:call-template name="link-default-title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
     <xsl:template name="hits">
       	<ul class="kiosque-list">
       		<xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="/search/hits">
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
       	</ul>	
    </xsl:template> 
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>kiosque-list-item<xsl:text> </xsl:text>
    </xsl:template> 
    
    <!-- Override: no form criteria available (but needed for html structure validation) -->
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form style="display: none" method="post" class="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
        </form> 
    </xsl:template>
    
    <!-- Override: remove results title and anchor -->
    <xsl:template name="form-result"/>
    
     <!-- Override: no pagination available-->
    <xsl:template name="pagination"/>  
    
    
</xsl:stylesheet>