<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">ametys-zone-webtv </xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
    	<!-- BEGIN head-css-owl-carousel -->
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel.min.css')}" type="text/css" />
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/owl-carousel-defaut-theme.min.css')}" type="text/css" />
	    <link media="screen, print" rel="stylesheet" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />
    	<!-- END head-css-owl-carousel -->
    	
		<link rel="stylesheet" href="{ametys:skinURL('zones/webtv/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/webtv/scss/print.css')}"/>
    </xsl:template>
    
     <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
         
		<script type="text/javascript" src="{ametys:skinURL('plugins/js/owl-carousel.min.js')}"></script>
		<script type="text/javascript">
		    function loadOwlCarousel_<xsl:value-of select="$uniqueId"/>()
            {
                $j('.ametys-zone-webtv .webtv-grid').owlCarousel({
                loop: false,
                margin: 50,
                dots: true,
                nav: false,
                responsive: {
                    0: {
                        items: 1,
                        slideBy: 1,
                    },
                    600: {
                        items: 2,
                        slideBy: 1
                    },
                    850: {
                        items: 3,
                        slideBy: 1
                    },
                    1024: {
                        items: 4,
                        slideBy: 1
                    },
                    1250: {
                        items: 5,
                        slideBy: 1
                    }
                },
                slideBy: 1
            })
          }
          
          $j(document).ready(function(){
              loadOwlCarousel_<xsl:value-of select="$uniqueId"/>();
		  })
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
          <div class="container">
            <div class="webtv-section">
              <xsl:call-template name="header"/>
              <xsl:call-template name="search-results"/>
            </div>
          </div>
        </div>
    </xsl:template>
    
    <!-- Override to avoid #nav anchor (FIXME CMS-11645). There is no criteria nor sorts in this view -->
    <!-- Keep this override for 4.7.x versions (unnecessary for 4.8.x) -->
    <xsl:template name="form-result"/>
    
    <xsl:template name="header">
        <div class="flex-title">
          <xsl:if test="/search/header/text()">
            <h1 class="service-title"><xsl:copy-of select="/search/header/text()"/></h1>
          </xsl:if>
            <div class="right">
                <xsl:call-template name="link"/> 
            </div>
        </div>      
   </xsl:template>
   
   <xsl:template name="link-attribute">
        <xsl:attribute name="class">btn</xsl:attribute>
        <i class="fas fa-arrow-right"></i>
    </xsl:template> 
    
    <xsl:template name="hits">
        <div class="webtv-grid owl-carousel" data-ametys-search-role="hits">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
        
    </xsl:template>

    <xsl:template name="hit">
      <div>
        <xsl:apply-templates select="."/>
      </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>webtv-grid-item<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template name="pagination"/>
    
</xsl:stylesheet>