<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">nouveaux-arrivants</xsl:variable>

    <xsl:template name="common-service-head-css">    
         <link rel="stylesheet" href="{ametys:skinURL('zones/nouveaux-arrivants/scss/main.css')}" />
    </xsl:template>
    
    <!-- Templates used for link "all contents" -->
    <xsl:template name="additionnal-link"/>
    
    <!-- Override to remove result div wrapper -->
    <xsl:template name="hits">
	    <ul data-ametys-search-role="hits">
	        <xsl:for-each select="/search/hits/hit">
	            <xsl:call-template name="hit"/>
	        </xsl:for-each>
	    </ul>
    </xsl:template>
    
    <!-- No attribut class for hits -->
    <xsl:template match="hit" mode="class-attribute">
    </xsl:template>
    
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <a class="btn">
                <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                <i class="fas fa-arrow-right" aria-hidden="true"></i>
                <xsl:call-template name="link-title"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    <!-- Override to remove 'hits-and-facets' div wrapper and remove facets  -->
    <xsl:template name="search-results-children">
        <xsl:call-template name="form-criteria-hidden"/>
        
        <xsl:if test="$result-display-type = 'ABOVE_CRITERIA' or $result-display-type = 'IN_PLACE_OF_CRITERIA'" >
            <xsl:call-template name="form-result"/>
            <xsl:call-template name="form-result-js"/>
        </xsl:if>
        
        <xsl:choose>
            <xsl:when test="/search/hits/hit">
                <xsl:call-template name="hits"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="/search/hits">
                    <!-- hits is present but no single hit => there is no result -->
                    <xsl:call-template name="no-result"/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Override: no form criteria available for this view (but needed for html structure validation) -->
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form style="display: none" method="post" class="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
        </form> 
    </xsl:template>
    
    <!-- Override to remove results title and anchor -->
    <xsl:template name="form-result"/>
    
</xsl:stylesheet>