<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">ametys-zone-offer</xsl:variable>
    
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>

    <xsl:template name="common-service-head-css">    
         <link rel="stylesheet" href="{ametys:skinURL('zones/offers/scss/main.css')}" />
    </xsl:template>
        
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="header"/>
        
        <xsl:call-template name="form-criteria"/>
        
        <xsl:call-template name="search-results"/>
    </xsl:template>
    
    <xsl:template name="header">
        <div class="flex-right">
            <h1 class="service-title">
                <xsl:value-of select="$header"/>
            </h1>
            <xsl:call-template name="link"/>
        </div>
   </xsl:template>
   
   <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <a class="btn">
                <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                <xsl:call-template name="link-attribute"/>
                <i class="fas fa-arrow-right"></i>
                <xsl:call-template name="link-title"/>
            </a>
        </xsl:if>
    </xsl:template>
   
   <xsl:template name="link-default-title">
        <i18n:text i18n:key="SKIN_SEARCH_ALL" i18n:catalogue="skin.{$skin}"/>
   </xsl:template>
    
   <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            <xsl:call-template name="form-criteria-hidden"/>
            <xsl:call-template name="hits"/>
        </div>
    </xsl:template>
    
   <xsl:template name="hits">
        <ul data-ametys-search-role="hits" class="ametys-offres">
            <xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="/search/hits">
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
        </ul>
    </xsl:template>
    
    <xsl:template name="hit">
        <li class="ametys-offres__item ametys-cms-content">
            <xsl:apply-templates select="content/html" mode="content"/>
        </li>
    </xsl:template>
    
    
    <xsl:template match="html" mode="content">
        <xsl:variable name="page-id" select="head/meta[@name = 'pages/page;id']/@content"/>
        
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}" class="ametys-offres__item__link">
                    <xsl:apply-templates select="." mode="badge"/>
                    <xsl:apply-templates select="." mode="title"/>
                    <xsl:apply-templates select="." mode="closing-date"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-offres__item__link">
                    <xsl:apply-templates select="." mode="badge"/>
                    <xsl:apply-templates select="." mode="title"/>
                    <xsl:apply-templates select="." mode="closing-date"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    <xsl:template match="html" mode="badge">
        <xsl:variable name="contractType" select="head/meta[@name='contractType;title']/@content"/>
        <xsl:if test="$contractType != ''">
            <span class="ametys-offres__item_badge">
                <xsl:value-of select="$contractType"/>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="html" mode="title">
        <xsl:variable name="title" select="head/meta[@name = 'title']/@content"/>
        
        <h2 class="ametys-offres__item_title"><xsl:value-of select="$title"/></h2>
    </xsl:template>
    
    <xsl:template match="html" mode="closing-date">
        <xsl:variable name="closingDate" select="head/meta[@name='closingDate']/@content"/>
        
        <xsl:if test="$closingDate != ''">
            <span class="ametys-offres__item_date">
                <span style="font-weight:bold;">
                    <i18n:text i18n:key="CONTENT_JOBOFFER_DATE_LABEL" i18n:catalogue="skin.{$skin}" />
                </span> <xsl:text> : </xsl:text>
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="medium"><xsl:value-of select="$closingDate"/></i18n:date>
            </span>
         </xsl:if>
    </xsl:template>
    
    <!-- No form criteria available for this view -->
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form style="display: none" method="post" class="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
        </form> 
    </xsl:template>
    
    <xsl:template name="additionnal-link"/>
    
    <!-- Override to remove results title and anchor -->
    <xsl:template name="form-result"/>
    
</xsl:stylesheet>