<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="math ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/user-password/password_3.5.xsl"/>
    <xsl:import href="service:web://pages/services/contenttype/helper/form.xsl"/>
    
    <xsl:template name="common-service-head-css">
    	<link rel="stylesheet" href="{ametys:skinURL('zones/signup/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="strong-password-head-js"/>
        
        <script type="text/javascript">
             $j(document).ready(function() {
                $j('.user-account.user-password form .field input').each(function(i, input) {
                    var label = $j(input).closest('.field').find('.label label').text();
                    $j(input).attr('placeholder', label);
                })
             });
        </script>
    </xsl:template>
    
    <!-- Override select population field -->
    <xsl:template name="population-field">
        <xsl:param name="value"/>
        
        <xsl:variable name="countPopulations" select="count(/user-password/UserPopulations/UserPopulation)"/>
        <xsl:choose>
            <xsl:when test="$countPopulations = 1">
                <input type="hidden" id="population-{$uniqueId}" name="population" value="{/user-password/UserPopulations/UserPopulation/@id}"/>
            </xsl:when>
            <xsl:otherwise>
                <div class="field field-select">
                    <div class="label">
                        <label for="population-{$uniqueId}">
                            <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_POPULATION" i18n:catalogue="plugin.web"/>
                            
                            <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
                        </label>
                    </div>
                    <div>
                        <xsl:attribute name="class">
                            <xsl:text>input</xsl:text>
                            <xsl:if test="/user-signup/errors/field[@name = 'population']/error"> invalid</xsl:if>
                        </xsl:attribute>
                        
                        <xsl:choose>
                            <xsl:when test="$countPopulations > 0">
                                <select id="population-{$uniqueId}" name="population" style="opacity: 0; position: absolute; top: -1000px">
                                    <xsl:for-each select="/user-password/UserPopulations/UserPopulation">
                                        <option value="{@id}">
                                            <xsl:if test="@id = $value"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                                            <xsl:copy-of select="label"/>
                                        </option>
                                    </xsl:for-each>
                                </select>
                                <input
                                    onfocus="this.select();"
                                    readonly="readonly"
                                    class="select-input"
                                    type="text"
                                    value="{$value}"
                                    onclick="openDropdown(this)">
                               </input>
                               <div class="select-dropdown monoselect">
                                    <div class="select-dropdown-list">
                                        <xsl:for-each select="/user-password/UserPopulations/UserPopulation">
                                            <div class="select-dropdown-item">
                                                <input type="checkbox" id="population-{position()}" value="{@id}"/>
                                                <label for="population-{position()}"><xsl:copy-of select="label/node()"/></label>
                                            </div>
                                        </xsl:for-each>
                                    </div>
                               </div>
                               <script>
                                  $j("#population-<xsl:value-of select="$uniqueId"/>").parent().find(".select-dropdown-item input").change(function () {
                                    onSelectOptions(this);
                                  });
                                  
                                   function openDropdown(input) {
                                        $j(input).next(".select-dropdown").toggle();
                                        $j(input).closest('.input').toggleClass("active");
                                    }
                                
                                    // On select option in criteria dropdown
                                    function onSelectOptions(optInput) {
                                        const $dropdownList = $j(optInput).closest(".select-dropdown");
                                        const optValue = $j(optInput).val();
                                        const $input = $dropdownList.parent().find(".select-input");
                                        const $selectInput = $input.prev("select");
                                    
                                        if ($j(optInput).is(":checked")) {
                                            // Unselect all other options
                                            $dropdownList.find("input").not(optInput).prop("checked", false);
                                            $input.val($j(optInput).next("label").text());
                                            $selectInput.val(optValue);
                                        } else {
                                            // No option selected
                                            $input.val("");
                                            $selectInput.val("");
                                        }
                                    }
                                    
                                    $j(document).click(function (e) {
                                        if (
                                            $j(e.target).closest(".select-input").length === 0 &amp;&amp;
                                            $j(e.target).closest(".select-dropdown").length === 0
                                        ) {
                                            $j(".select-dropdown").hide();
                                            $j(".select-input").closest('.input').removeClass("active");
                                        }
                                    });
                                </script>
                            </xsl:when>
                            <xsl:otherwise>
                                <input type="text" id="population-{$uniqueId}" name="population" value="{$value}"/>
                            </xsl:otherwise>
                        </xsl:choose>
                   </div>
            </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <!-- Override to use <button> instead of <input> -->
    <xsl:template name="common-utils-input-submit">
        <xsl:param name="class-name"/>
        <xsl:param name="text"/>
        <xsl:param name="i18nkey"/>
        <xsl:param name="name"/>   
        <xsl:param name="i18ntitle"/>  
        <xsl:param name="title"/>             
        <xsl:param name="id"/>        
        <xsl:param name="onclick"/>        
        <xsl:param name="width"/>        
        <xsl:param name="type">submit</xsl:param>        
        <xsl:param name="disabled" select="false()"/>        
        
        <div class="button">
            <button type="{$type}">
                <xsl:if test="$class-name != ''">
                    <xsl:attribute name="class"><xsl:value-of select="$class-name"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$name != ''">
                    <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$id != ''">
                    <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$onclick">
                    <xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$disabled">
                    <xsl:attribute name="disabled">disabled</xsl:attribute>
                </xsl:if>
                <xsl:if test="$width != ''">
                    <xsl:attribute name="style">width: <xsl:value-of select="$width"/>px;</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="$i18nkey != ''">
                        <i18n:text i18n:key="{substring-after($i18nkey, ':')}" i18n:catalogue="{substring-before($i18nkey, ':')}"/>
                    </xsl:when>
                    <xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise>                
                </xsl:choose>
            </button>
        </div>        
    </xsl:template>        
   
</xsl:stylesheet>
