<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
        extension-element-prefixes="resolver">

    <xsl:import href="plugin:workspaces://pages/services/projects/activity-stream/activity-stream.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">activity</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/activity-feed/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="moment-date-js"/>
        <xsl:call-template name="activity-stream-js"/>
        
        <script type="text/javascript">
            function isInViewport(element) {
                var rect = element.getBoundingClientRect();
                return (
                    rect.top >= 0 &amp;&amp;
                    rect.left >= 0 &amp;&amp;
                    rect.bottom &lt;= (window.innerHeight || document.documentElement.clientHeight) &amp;&amp;
                    rect.right &lt;= (window.innerWidth || document.documentElement.clientWidth)
                );
            }
            
            function hideUnreadIndicators()
            {   
                $j("#activity-stream-<xsl:value-of select="$uniqueId"/> .ametys-notifications__list_item .ametys-indicator").hide();
            }
            
            // Observer to known if first activity is currently visible on screen
            const activityObserver = new IntersectionObserver(function(entries) {
                // isIntersecting is true when element and viewport are overlapping
                // isIntersecting is false when element and viewport don't overlap
                if(entries[0].isIntersecting === true)
                {
                    // activity stream is fully visible, events will be mark as read at next loading
                    ActivityStream.setMarkAsRead(true);
                    
                    // Hide unread indicators after 30s when activity stream becomes visibles
                    setTimeout(hideUnreadIndicators, 10 * 1000)
                }
                else
                {
                    // activity stream is no more visible, events will be mark as unread at next loading
                    ActivityStream.setMarkAsRead(true);
                }
            }, { threshold: [1] });
            
            $j(document).ready(function(){
                // Active ping for getting new events
                ActivityStream.getNumberOfUnreadEvents("#activity-stream-<xsl:value-of select="$uniqueId"/>");
                
                window.VEvent.listen("activity-stream-loading", function(data) {
                    // Show loader
                    $j('.activity__feed__loader').addClass('open');
                })
                
                window.VEvent.listen("activity-stream-outofdate", function(data) {
                    // Reload activity stream
                    ActivityStream.open("#activity-stream-<xsl:value-of select="$uniqueId"/>", null, true, false);
                })
                
                window.VEvent.listen("activity-stream-loaded", function(data) {
                    // Hide loader
                    $j('.activity__feed__loader').removeClass('open');
                    
                    // Handle show more links
                    $j('.ametys-notifications__list .ametys-sidebar-voir').unbind('click');
                    $j('.ametys-notifications__list .ametys-sidebar-voir').bind('click', function () {
                        $j(this).parent().find('.ametys-q-panel__list_subtxt--limit').toggleClass('open');
                        if ($j(this).parent().find('.ametys-q-panel__list_subtxt--limit').hasClass('open'))
                        {
                            $j(this).text("<i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_LESS" i18n:catalogue="skin.{$skin}"/>");
                            $j(this).parent().find('.ametys-q-panel__list_subtxt--limit > li:nth-child(n+3) a').removeAttr("tabindex");
                            $j(this).parent().find('.ametys-q-panel__list_subtxt--limit > li:nth-child(3) a').focus();
                        }
                        else
                        {
                            $j(this).parent().find('.ametys-q-panel__list_subtxt--limit > li:nth-child(n+3) a').attr("tabindex", -1);
                            $j(this).parent().find('.ametys-q-panel__list_subtxt--limit > li:nth-child(3) a').focus();
                            $j(this).text("<i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>");
                        }
                    });  
                    
                    // Hide unread indicators after 30s if first activity is fully visible
                    var $firstActivity = $j(".activity__feed .ametys-notifications__list .ametys-notifications__list_item:first-child");
                    if ($firstActivity &amp;&amp; isInViewport($firstActivity.get(0)))
                    {
                        setTimeout(hideUnreadIndicators, 10 * 1000);
                    }
                    
                    if (!data.append)
                    {
                        activityObserver.observe($firstActivity.get(0));
                    }
                });
                
                // Load activity stream without mark as read activities
                ActivityStream.setMarkAsRead(false);
                ActivityStream.open("#activity-stream-<xsl:value-of select="$uniqueId"/>");
            });
        </script>
    </xsl:template>
    
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <a name="activity-stream"/>
        
        <div id="activity-stream-{$uniqueId}">
            <xsl:call-template name="activity-filter"/>
            
            <div class="activity__feed">
                <xsl:call-template name="activity-loader"/>
                
                <!-- Message in the case of error -->
                <xsl:call-template name="error-msg"/>
                    
                <div class="activity__feed__wrapper">
                    <div data-ametys-activitystream-role="results">
                        <!-- Activity stream will be inserted here -->
                    </div>
                    
                    <!-- No result -->
                    <xsl:call-template name="no-result"/>
                
                    <!-- Show more button -->
                    <xsl:call-template name="show-more"/>
                </div>
            </div>
        </div>
        
        <script>
            function showMoreFeed()
            {
                ActivityStream.open("#activity-stream-<xsl:value-of select="$uniqueId"/>", null, true /*force*/, true /*append*/);
            }
        </script>
    </xsl:template>
    
    <xsl:template name="no-result">
        <div data-ametys-activitystream-role="no-result" class="no-result" style="display: none">
            <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_NO_RESULT" i18n:catalogue="skin.{$skin}"/>
        </div>
    </xsl:template>
    
    <xsl:template name="error-msg">
        <div data-ametys-activitystream-role="error-msg" class="error" style="display: none">
            <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_ERROR_MSG" i18n:catalogue="skin.{$skin}"/>
        </div>
    </xsl:template>
    
    <xsl:template name="show-more">
        <div class="show-more__wrapper">
            <button data-ametys-activitystream-role="show-more" class="show-more" onclick="showMoreFeed()" style="display: none" title="skin.{$skin}:SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE_BTN_TITLE" i18n:attr="title">
                <i class="fas fa-arrow-down" aria-hidden="true"></i>
                <span><i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE_BTN" i18n:catalogue="skin.{$skin}"/></span>
            </button>
        </div>
    </xsl:template>
    
    <xsl:template name="activity-loader">
        <div class="activity__feed__loader">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="51px" height="51px"
                viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                <circle cx="50" cy="50" fill="none" stroke="#0a0a0a" stroke-width="10" r="35" stroke-dasharray="164.93361431346415 56.97787143782138">
                    <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" values="0 50 50;360 50 50" keyTimes="0;1"></animateTransform>
                </circle>
            </svg>
        </div>
    </xsl:template>
    
    <xsl:template name="activity-filter">
        <form class="activity__filter" data-ametys-activitystream-role="filters">
            <xsl:call-template name="filter-search-icon"/>
            
            <!-- Input text -->
            <input type="text" class="activity__filter__input" name="pattern" placeholder="skin.{$skin}:SKIN_SERVICE_ACTIVITY_STREAM_FILTER_PLACEHOLDER" i18n:attr="placeholder"/>
            <i class="fa fa-chevron-down" aria-hidden="true"></i>
            
            <div class="activity__filter__count">0</div>
            
            <xsl:call-template name="filter-dropdown"/>
        </form>
        
        <xsl:call-template name="activity-filter-js"/>
     </xsl:template>
     
     <xsl:template name="activity-filter-js">   
        <script>
            // Open filter
            $j(document).on('click', '.activity__filter i', function() {
                $j(this).parent().toggleClass('open');
            });
            
            // Close filter
            $j(document).click(function (e) {
                if (
                  $j(e.target).closest(".activity__filter").length === 0 &amp;&amp;
                  $j(e.target).closest(".filter-activity-dropdown").length === 0
                ) {
                  $j(".activity__filter").removeClass('open');
                }
            });
            
            let keyUpTimer_<xsl:value-of select="$uniqueId"/> = null;
            $j(document).on('keyup', '.activity__filter input', function() {
                // clear the previous timer
                clearTimeout(keyUpTimer_<xsl:value-of select="$uniqueId"/>);
                
                keyUpTimer_<xsl:value-of select="$uniqueId"/> = setTimeout(() => {
                    let pattern = $j(this).val();
                    if ($j(this).val().length >= 3 || pattern == '') {
                        searchOnActivityFeed();
                    } 
                }, 300);
            });
                
            // Handle click on "all" filter option
            $j(".filter-activity-dropdown input[value='']").change(function () {
                const $dropdownList = $j(this).closest('.filter-activity-dropdown');
                
                if ($j(this).is(":checked")) 
                {
                  // unselect all other options if check "all" option
                  $dropdownList
                     .find("input[value!='']")
                     .prop("checked", false);
                     
                   $j('.activity__filter__count').text(0);
                   $j('.activity__filter').removeClass('filter-active');
              	}
                searchOnActivityFeed();
            });
            
              
            $j(".filter-activity-dropdown input[value!='']").change(function () {
                const $dropdownList = $j(this).closest('.filter-activity-dropdown');
                const $allOpt = $dropdownList.find("input[value='']");
                const activeCount = $dropdownList.find("input[value!='']:checked").length;
                
                if ($allOpt.is(":checked") &amp;&amp; $j(this).is(":checked")) 
                {
                    // unselect "all" option
                    $allOpt.prop("checked", false);
                }
                else if (activeCount == 0) 
                {
                   // no option selected => check 'all' option
                   $allOpt.prop("checked", true);
                }
                
                $j('.activity__filter__count').text(activeCount);
                activeCount == 0 ? $j('.activity__filter').removeClass('filter-active') : $j('.activity__filter').addClass('filter-active');
                
                searchOnActivityFeed();
            });
            
            function searchOnActivityFeed()
            {
                // Reload activity stream
                ActivityStream.setMarkAsRead(true);
                ActivityStream.open("#activity-stream-<xsl:value-of select="$uniqueId"/>", null, true /* append */, false /* false */);
            }
        </script>
    </xsl:template>
    
    <xsl:template name="filter-search-icon">
        <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <title>E02DBFDF-F11A-4272-8824-8A024B4F7191</title>
            <g id="Produit" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g transform="translate(-142.000000, -254.000000)" fill="#795198" fill-rule="nonzero" id="workspace">
                    <g transform="translate(65.000000, 160.000000)">
                        <g id="Filtre" transform="translate(57.000000, 84.000000)">
                            <g id="ICON-LOUPE" transform="translate(20.000000, 10.000000)">
                                <path d="M21.152057,16.6163471 C24.9493143,12.8203129 24.9493143,6.64305977 21.152057,2.84702562 C17.3547996,-0.949008539 11.1755559,-0.949008539 7.37829851,2.84702562 C4.15333654,6.07094872 3.66611207,10.8565804 5.9166251,14.5984959 C5.9166251,14.5984959 6.07903325,14.869089 5.86248905,15.0855634 C4.61735984,16.3302915 0.889705954,20.0567446 0.889705954,20.0567446 C-0.100210431,21.0463421 -0.332222084,22.4302324 0.541688475,23.3038614 L0.69636291,23.458486 C1.57027347,24.3321151 2.95460966,24.1001781 3.94452605,23.1105807 C3.94452605,23.1105807 7.66444622,19.3918588 8.9018417,18.1548619 C9.13385335,17.922925 9.39679989,18.0852809 9.39679989,18.0852809 C13.1399212,20.3196065 17.927095,19.8325389 21.152057,16.6163471 Z M9.17252196,14.8149704 C6.36518096,12.0085337 6.36518096,7.44710774 9.17252196,4.64067108 C11.979863,1.83423443 16.5427588,1.83423443 19.3500998,4.64067108 C22.1574408,7.44710774 22.1574408,12.0085337 19.3500998,14.8149704 C16.5427588,17.621407 11.979863,17.621407 9.17252196,14.8149704 Z" id="Shape"></path>
                                <path d="M10.0087625,10 C9.87716375,10 9.74556499,9.9735209 9.61396624,9.91173632 C9.10305344,9.664598 8.86307924,8.99379401 9.07983013,8.4112537 C10.4422643,4.73948448 14.1657349,3.01834266 17.3860338,4.57178348 C17.8969466,4.8189218 18.1369208,5.48972579 17.9201699,6.0722661 C17.703419,6.65480641 17.1150952,6.92842382 16.6041823,6.68128551 C14.4057091,5.62212131 11.8666272,6.7960283 10.9376949,9.3027169 C10.7673906,9.73520895 10.3958177,10 10.0087625,10 Z" id="Path"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="filter-dropdown">
        <div class="filter-activity-dropdown">
            <div class="filter-activity-dropdown-list">
                <!-- All option (clear filters) -->
                <xsl:call-template name="filter-all-option"/>
                
                <!-- Themes -->
                <xsl:call-template name="filter-categories"/>
                
                <!-- Modules -->
                <xsl:call-template name="filter-modules"/>
            </div>
        </div>
        
        <script>
            $j(".filter-activity-show-more").on('click', function () {
                const dataIsMore = $j(this).attr('data-is-more');
                const dataShowMore = $j(this).attr('data-show-more');
                
                if(dataIsMore == "false") {
                    $j(`.filter-activity-dropdown .filter-activity-dropdown-item input[name='${dataShowMore}']`).parent().show();
                    $j(this).attr('data-is-more', 'true');
                    $j(this).text('<i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_LESS" i18n:catalogue="skin.{$skin}"/>');
                } else {
                    $j(`.filter-activity-dropdown .filter-activity-dropdown-item input[name='${dataShowMore}']:gt(4)`).parent().hide();
                    $j(this).attr('data-is-more', 'false');
                    $j(this).text('<i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>');
                }
            });
        </script>
    </xsl:template>
    
    <xsl:template name="filter-all-option">
         <div class="filter-activity-dropdown-item">
            <input type="checkbox" checked="checked" id="activities-filter-all-opt-{$uniqueId}" value=""/> 
            <label for="activities-filter-all-opt-{$uniqueId}"><i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_FILTER_ALL" i18n:catalogue="skin.{$skin}"/></label>
        </div>
    </xsl:template>
    
    <xsl:template name="filter-categories">
        <div class="filter-activity-dropdown-title">
            <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_FILTER_CATEGORIES" i18n:catalogue="skin.{$skin}"/>
        </div>
        
        <xsl:for-each select="/Workspaces/categories/category">
            <xsl:sort select="."/>
            
            <div class="filter-activity-dropdown-item">
                <xsl:if test="position() > 5"><xsl:attribute name="style">display:none;</xsl:attribute></xsl:if>
                <input type="checkbox" name="categories" id="activities-category-{position()}" value="{@name}"/> 
                <label for="activities-category-{position()}"><xsl:value-of select="."/></label>
            </div>
        </xsl:for-each>
        
        <xsl:if test="count(/Workspaces/categories/category) &gt; 5">
            <a href="javascript:void(0)" class="filter-activity-show-more" data-is-more="false" data-show-more="categories">
                <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="filter-modules">
        <div class="filter-activity-dropdown-title">
            <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_FILTER_MODULES" i18n:catalogue="skin.{$skin}"/>
        </div>
        
        <xsl:for-each select="/Workspaces/modules/module">
            <xsl:sort select="."/>
            <div class="filter-activity-dropdown-item">
                <xsl:if test="position() > 4"><xsl:attribute name="style">display:none;</xsl:attribute></xsl:if>
                <input type="checkbox" name="modules" id="activities-module-{position()}" value="{@id}"/> 
                <label for="activities-module-{position()}"><xsl:value-of select="."/></label>
            </div>
        </xsl:for-each>
        
        <xsl:if test="count(/Workspaces/modules/module) &gt; 5">
            <a href="javascript:void(0)" class="filter-activity-show-more" data-is-more="false" data-show-more="modules">
                <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    
</xsl:stylesheet>