<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:docbook="http://docbook.org/ns/docbook" 
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:cms="http://ametys.org/cms/3.0"
    exclude-result-prefixes="ametys resolver docbook">    
    
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    
    <xsl:variable name="zoneItemPosition" select="ametys:zoneItemPosition()"/>
    <xsl:variable name="hideTitle" select="$zone = 'default' and ametys:zoneParameter('default', 'hideTitle') = 'true'" />
    
    <xsl:template name="common-content-head-css">
         <link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" media="screen, print, handheld"/>
         
         <xsl:call-template name="custom-content-css"/>
    </xsl:template>
    
    <!-- Custom css class for content rendering -->
    <xsl:template name="custom-content-css"/>
    
    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
		<xsl:if test="not($hideTitle) and not($zone = 'default' and $zoneItemPosition = 1)">
	        <h1 class="content-title">
	        	<span class="content-title summary"><xsl:value-of select="$title"/></span>
	            <xsl:if test="$subtitle != ''">
	                <span class="content-subtitle"><xsl:value-of select="$subtitle"/></span>
	            </xsl:if>
	        </h1>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-content-body-publish-date"/>
    
    <xsl:template name="common-content-body-meta">
    	<xsl:if test="metadata/contact/name or metadata/contact/mail or @lastValidatedAt">
    		<div class="meta">
    			<xsl:call-template name="common-content-body-contact"/>
	    	</div>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="comment-form-showhint"/>
    
    <!-- Template used to display the content illustration -->
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        
        <xsl:if test="$image">
            <img alt="{$alternative}" class="{$class}">
                <xsl:attribute name="src">
                 <xsl:choose>
                     <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                     <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                 </xsl:choose>
                </xsl:attribute>
            </img>
        </xsl:if>        
    </xsl:template>
    
    <!-- Override to take into account 'hideTitle' parameter value for hX levels -->
    <xsl:template name="common-content-body-content-rich">
        <xsl:param name="level" select="0"/>
        <xsl:param name="content" select="metadata/content"/>

        <xsl:variable name="minLevel">
            <xsl:choose>
                <xsl:when test="$zone = 'default' and ($hideTitle)">0</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:if test="cms:isNotRichTextEmpty($content)">
            <xsl:variable name="raw-is-title-visible">
                <xsl:call-template name="common-content-body-title-content"/>
            </xsl:variable>
            
            <xsl:variable name="truelevel">
                <xsl:choose>
                    <xsl:when test="string-length($raw-is-title-visible) &gt; 0"><xsl:value-of select="number($minLevel) + 1 + number($level)"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="number($minLevel) + number($level)"/></xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
                    
            <xsl:apply-templates select="$content/docbook:article">
                <xsl:with-param name="level" select="$truelevel"/>
            </xsl:apply-templates>
        </xsl:if>    
    </xsl:template>
    
</xsl:stylesheet>    