<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:cms="http://ametys.org/cms/3.0"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
							exclude-result-prefixes="ametys resolver">

	<xsl:import href="plugin:job-offer://stylesheets/content/jobOffer/jobOffer-main.xsl"/>
	<xsl:import href="skin://stylesheets/content/jobOffer/jobOffer.xsl"/>	
	
	<xsl:variable name="common-content-css-class-name">job-offer view-main</xsl:variable>
	
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content"/>
    </xsl:template> 
    
	<xsl:template name="common-content-body-content">
        <xsl:call-template name="job-refid"/>
        <xsl:call-template name="closing-date"/>
        <xsl:call-template name="start-date"/>
        
		<xsl:call-template name="job-description"/>
        <xsl:call-template name="job-profile"/>
        <xsl:call-template name="job-contacts"/>
        <xsl:call-template name="job-additional-info"/>
        
    </xsl:template> 
    
    <xsl:template name="job-refid">
        <xsl:if test="metadata/refId">
            <div class="flex-icon">
                <span class="material-icons">work</span>
                <strong><i18n:text i18n:key="CONTENT_JOB_OFFER_ID" i18n:catalogue="plugin.job-offer"/>:&#160;</strong>
                 <xsl:value-of select="metadata/refId" />
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="closing-date">
        <xsl:if test="metadata/closingDate">
            <div class="flex-icon">
                <span class="material-icons">access_time</span>
                <strong><i18n:text i18n:key="SKIN_JOBOFFER_CONTENT_END_DATE" i18n:catalogue="skin.{$skin}"/>:&#160;</strong>

                <xsl:call-template name="date-format">
	                <xsl:with-param name="date" select="metadata/closingDate"/>
	            </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="start-date">
        <xsl:if test="metadata/startDate">
            <div class="flex-icon">
                <span class="material-icons">access_time</span>
                <strong><i18n:text i18n:key="CONTENT_JOB_OFFER_START_DATE" i18n:catalogue="plugin.job-offer"/>:&#160;</strong>

                <xsl:call-template name="date-format">
                    <xsl:with-param name="date" select="metadata/startDate"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-description">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/content)">
            <h1 class="ametys-richtext-title-2"><i18n:text i18n:key="CONTENT_JOB_OFFER_CONTENT" i18n:catalogue="plugin.job-offer"/></h1>
            <xsl:call-template name="common-content-body-content-rich" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-profile">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/requiredProfile)">
            <h1 class="ametys-richtext-title-2"><i18n:text i18n:key="CONTENT_JOB_OFFER_PROFILE_REQUIRED" i18n:catalogue="plugin.job-offer"/></h1>
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/requiredProfile"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-contacts">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/contacts)">
            <h1 class="ametys-richtext-title-2">
                <i18n:text i18n:key="CONTENT_JOB_OFFER_CONTACT" i18n:catalogue="plugin.job-offer"/>
            </h1>
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/contacts"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-additional-info">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/additionalInfo)">
            <h1 class="ametys-richtext-title-2"><i18n:text i18n:key="CONTENT_JOB_OFFER_ADDITIONAL_INFO" i18n:catalogue="plugin.job-offer"/></h1>
            <xsl:call-template name="common-content-body-content-rich">
                <xsl:with-param name="content" select="metadata/additionalInfo"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    

</xsl:stylesheet>
