<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="ametys docbook"
                              extension-element-prefixes="text resolver user">

	<xsl:import href="plugin:web://stylesheets/content/article/article-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl" />
    
    <xsl:variable name="common-content-css-class-name">item annuary-item</xsl:variable>
	
	<xsl:template name="common-content-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/static_service_search.css')}" />
	</xsl:template>
	
	<xsl:template name="common-content-head-js">
		<!-- TOOLTIP -->
	    <script src="{ametys:skinURL('plugins/js/popper.min.js')}"></script>
	    <script src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}"></script>
		
		<script>
		    $j(document).ready(function () {
	            tippy('[data-tippy-content]', {});
	        });
	
	        $j(document).on('click', '.annuary-item', function (e) {
	            const hasPreventDefault = e.target.getAttribute("data-prevent-default");
	
	            if (hasPreventDefault !== true) {
	                const link = $j(this).find('a:first').attr('href');
	            }
	        });
	   </script>
	</xsl:template>
	
	<xsl:template name="common-content-body">
		<section class="{$common-content-css-class-name}">
            <div class="content">
        	   <xsl:call-template name="common-content-body-content"/>
            </div>
        </section>
    </xsl:template>
	
	<xsl:template name="common-content-body-content">
		<xsl:variable name="page-id" select="user:getUserPage(@id)"/>
		
		<!-- Image -->
		<a href="{resolver:resolve('page', $page-id, false)}">
			<xsl:call-template name="user-image"/>
        </a>
        	
		<!-- Member name -->
		<a href="{resolver:resolve('page', $page-id, false)}">
			<span class="name"><xsl:value-of select="metadata/firstname"/><xsl:text> </xsl:text><xsl:value-of select="metadata/lastname"/></span>
		</a>
		
        <xsl:call-template name="user-function"/>
		
		<xsl:call-template name="user-phone"/>
	    
	    <xsl:if test="normalize-space(metadata/email) != ''">
	        <a class="flex" data-prevent-default="true" data-tippy-content="{metadata/email}"
	            href="mailto:{metadata/email}"><i class="fas fa-envelope"
	                data-prevent-default="true"></i>
	            <span class="email" data-prevent-default="true">
	            	<xsl:value-of select="metadata/email"/>
	            </span>
	        </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-function">
        <xsl:if test="metadata/function">
            <span class="function"><xsl:value-of select="metadata/function"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-phone">
        <xsl:choose>
            <xsl:when test="normalize-space(metadata/phone) != ''">
                <a class="flex" data-prevent-default="true" href="tel:{metadata/phone}">
                    <i class="fas fa-phone" data-prevent-default="true"></i>
                    <span class="phone" data-prevent-default="true"><xsl:value-of select="metadata/phone"/></span>
                </a>
            </xsl:when>
            <xsl:when test="normalize-space(metadata/mobile) != ''">
                <a class="flex" data-prevent-default="true" href="tel:{metadata/mobile}">
                    <i class="fas fa-phone" data-prevent-default="true"></i>
                    <span class="phone" data-prevent-default="true"><xsl:value-of select="metadata/mobile"/></span>
                </a>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="user-image">
        <div class="picture">
            <xsl:choose>
                <xsl:when test="metadata/illustration/image">
                    <img alt="{metadata/illustration/alt-text}" src="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@path, 81, 81)}" />
                </xsl:when>
                <xsl:when test="metadata/user">
                    <xsl:call-template name="user-profile-image">
                        <xsl:with-param name="size">81</xsl:with-param>
                        <xsl:with-param name="login" select="metadata/user/@login"/>
                        <xsl:with-param name="population" select="metadata/user/@populationId"/>
                        <xsl:with-param name="lang" select="@language"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="user-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="user-default-image">
        <img src="{ametys:skinURL('templates/common/img/avatar.png')}" width="81"/>
    </xsl:template>
</xsl:stylesheet>