<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							exclude-result-prefixes="ametys">
							
	<xsl:import href="myfavorites-main.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">favorites-list</xsl:variable>
	
	<xsl:template name="entries"> 
        <xsl:if test="metadata/link/entry[url != '']">
            <ul>
                <xsl:apply-templates select="metadata/link/entry[url != '']"/>
            </ul>
        </xsl:if>
	</xsl:template>
	
	<xsl:template match="entry"> 
		<li>
			<a onclick="window.open(this.href); return false;" href="{url}" title="{link-title}" class="label">
				<span><xsl:value-of select="label"/></span>
				<i class="fas fa-external-link-alt"></i>
            </a>
		</li>
	</xsl:template>
	
</xsl:stylesheet>
