<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
							exclude-result-prefixes="ametys resolver docbook"
							xmlns:datetime="http://ametys.org/datetime/4.2"
                            extension-element-prefixes="datetime">

	<xsl:import href="plugin:news://stylesheets/content/news/news-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>	
	
    <xsl:template name="content-default-image-picto">
        <i class="intraneticon-content"></i>
    </xsl:template>
    
    <xsl:template name="content-date">
        <xsl:param name="startDate" select="metadata/start-date"/>
        <xsl:param name="endDate"  select="metadata/end-date"/>
        
        <xsl:if test="$startDate or $endDate">
            <xsl:call-template name="dates">
                <xsl:with-param name="startDate" select="$startDate"/>
                <xsl:with-param name="endDate" select="$endDate"/>
            </xsl:call-template>    
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="dates">
		<xsl:param name="startDate"/>
		<xsl:param name="endDate"/>
		
		<aside class="date">
			<xsl:choose>
				<xsl:when test="$startDate and not($endDate)">
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
						<xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$endDate and not($startDate)">
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$endDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$startDate and $endDate and datetime:sameDate($startDate, $endDate)">
                    <!-- case when the two datetimes represent the same date -->
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$startDate and $endDate">
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
					<xsl:text> - </xsl:text>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$endDate"/>
                        <xsl:with-param name="role" select="'dtend'"/>
					</xsl:call-template>
				</xsl:when>
				
			</xsl:choose>
		</aside>
	</xsl:template>
    
	<!-- Template used for date format -->
    <xsl:template name="common-utils-date-pattern">
        <xsl:param name="date"/>
        
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="dd MMM"><xsl:value-of select="$date"/></i18n:date>
    </xsl:template>     	
</xsl:stylesheet>
