<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook"
                            xmlns:exslt="http://exslt.org/common" 
							exclude-result-prefixes="ametys resolver docbook"
							xmlns:datetime="http://ametys.org/datetime/4.2"
                            extension-element-prefixes="datetime exslt">

	<xsl:import href="plugin:news://stylesheets/content/news/news-abstract.xsl"/>	
	<xsl:import href="news.xsl"/>
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>		
	
	<xsl:template name="common-content-body-title"/>
	
	<xsl:template name="class-name">
    	<xsl:choose>
			<xsl:when test="metadata/illustration/image">item actu-item</xsl:when>
			<xsl:otherwise>item actu-item without-image <xsl:value-of select="local-name(/)"/></xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <xsl:template name="common-content-body">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
    
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:attribute name="class">
                <xsl:call-template name="class-name"/>
            </xsl:attribute>
            <xsl:call-template name="common-content-body-content"/>
        </a>
    </xsl:template>
	
	<xsl:template name="tag">
	   <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
	       <xsl:for-each select="exslt:node-set($tags)/tag[position() = '1']">
               <div class="tag">
                    <xsl:if test="$useTagColor and @bgColor">
                        <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="." />
               </div>
            </xsl:for-each>
	</xsl:template>
	
	<xsl:template name="common-content-body-content">
		<xsl:variable name="image" select="metadata/illustration/image"/>
		<xsl:choose>
			<xsl:when test="$image">
				<xsl:variable name="src" select="resolver:resolveCroppedImage($image/@type, $image/@path, '160', '240')"/>
				<div class="picture" style="background-image:url({ametys:escapeURLforCSS($src)})">
					<img src="{$src}"></img>
	 				<xsl:call-template name="tag"/>
 				</div>
			</xsl:when>
			<xsl:otherwise>
				<div class="picture">
					<xsl:call-template name="tag"/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
        
		<!-- Title -->
		<div class="title"><xsl:value-of select="metadata/title"/></div>
        
        <xsl:call-template name="date"/>
    </xsl:template>
    
    <!-- No date by default, overrides this template to add one -->
    <xsl:template name="date">
        <!-- Sample -->
        <!-- <span class="date">22 octobre 2022</span> -->
    </xsl:template>
    
</xsl:stylesheet>
