<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							exclude-result-prefixes="ametys resolver">

	<xsl:import href="plugin:multimedia://stylesheets/content/photosGallery/photosGallery-main.xsl"/>	
	<xsl:import href="photosGallery.xsl"/>	
	
	<xsl:template name="common-content-head-css">
		<link rel="stylesheet" href="{ametys:skinURL('plugins/simple-lightbox/simple-lightbox.min.css')}"/>
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/static_service_actu.css')}" />
	</xsl:template>
	
	<xsl:template name="common-content-head-js">
		<script type="text/javascript" src="{ametys:skinURL('plugins/simple-lightbox/simple-lightbox.jquery.min.js')}"></script>
		<script type="text/javascript" src="{ametys:skinURL('plugins/js/masonry.min.js')}"></script>	
		<script type="text/javascript">
	        $j(document).ready(function () {
	            $j('.ametys-zone-gallery a').simpleLightbox();
	            
	            setTimeout(function () {
		            $j('.actus').masonry({
		                itemSelector: '.actu-item',
		                gutter: 0
		            });
		        }, 800);
		        
	          const $grids = $j('.actus');
              $grids.masonry('reloadItems');
              $grids.masonry('layout');
	        });
	         
	    </script>
	</xsl:template>
	
	<xsl:template name="common-content-body-content">
		<xsl:if test="not($zone = 'default' and ($template = 'page' or $template = 'full-page'))">
            <!-- Image -->
            <xsl:call-template name="common-content-body-image-bigsize">
            	<xsl:with-param name="maxWidth" select="'720'"/>
            	<xsl:with-param name="maxHeight" select="'480'"/>
            </xsl:call-template>    
        </xsl:if>
        
        <!-- Rich content -->
        <xsl:call-template name="common-content-body-content-rich"/>
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
        
        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>
        
        <div class="ametys-cms-service ametys-zone-actu ametys-zone-gallery">
	       <!-- Photos -->            
            <xsl:call-template name="photos"/>
        </div>
    </xsl:template> 
    
    <xsl:template name="photos">
		<xsl:if test="metadata/photos/entry/image">
			<div class="actus">
				<xsl:for-each select="metadata/photos/entry[image]">
					<xsl:call-template name="photo"/>
				</xsl:for-each>
			</div>
			
			
		</xsl:if>
	</xsl:template>
	
	 <xsl:template name="photo">
		<a href="{resolver:resolve(image/@type, image/@path)}" class="actu-item">
<!-- 			<xsl:attribute name="rel"> -->
<!-- 				<xsl:choose> -->
<!-- 					<xsl:when test="count(../entry[image]) &gt; 1"><xsl:text>gallery</xsl:text></xsl:when> -->
<!-- 					<xsl:otherwise><xsl:text>single</xsl:text></xsl:otherwise> -->
<!-- 				</xsl:choose> -->
<!-- 			</xsl:attribute> -->
			
<!-- 			<xsl:attribute name="class"> -->
<!-- 				<xsl:text>pirobox</xsl:text> -->
<!-- 				<xsl:if test="count(../entry[image]) &gt; 1"><xsl:text>_gall_</xsl:text><xsl:value-of select="$uniqueId"/></xsl:if> -->
<!-- 			</xsl:attribute> -->

			<xsl:attribute name="title">
				<xsl:choose>
					<xsl:when test="alt-text != ''"><xsl:value-of select="alt-text"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="image/@filename"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			
			<xsl:if test="$rendering-context = 'back'">
				<xsl:attribute name="internal">internal</xsl:attribute>
			</xsl:if>
			<div class="image-wrapper">
                <xsl:variable name="imgUrl" select="resolver:resolveCroppedImage(image/@type, image/@path, '200', '200')"/>
				<xsl:attribute name="style">background-image: url(<xsl:value-of select="ametys:escapeURLforCSS($imgUrl)"/>);</xsl:attribute>
				<img src="{$imgUrl}" alt="{alt-text}"/>
			</div>
		</a>
    </xsl:template>
	
</xsl:stylesheet>
