<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:math="http://exslt.org/math" 
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="ametys math exslt resolver">
    
    <xsl:import href="plugin:forms://stylesheets/forms/questions/file.xsl"/>
    
    <xsl:template match="question[@type = 'form.File']" mode="input-attribute-class">
        <xsl:attribute name="class">input input-file download-input</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.File']" mode="input">
        <xsl:variable name="inputId" select="concat(@name, '_', $uniqueId)"/>
        
        <xsl:variable name="fnSuffixId" select="concat(translate(@name, '-', '_'), '_', $uniqueId)"/>
        
        <div class="close" onclick="removeFile_{$fnSuffixId}(this)">
            <span class="material-icons">close</span>
        </div>
        <div id="input-{$inputId}"> 
	        <label>
	            <input id="{$inputId}" type="file" name="{@name}" onchange="changeFile_{$fnSuffixId}(this, '{$inputId}')">
	                <xsl:if test="validation/mandatory = 'true'"><xsl:attribute name="data-ametys-mandatory">true</xsl:attribute></xsl:if>
                    <xsl:if test="additional-infos/allowed-extensions">
                        <xsl:attribute name="accept"><xsl:value-of select="additional-infos/allowed-extensions"/></xsl:attribute>
                   </xsl:if>
	            </input>
                
                <xsl:choose>
                    <xsl:when test="entry-value/value">
                        <span><a href="{resolver:resolve('attribute', entry-value/value/@uri, 'true')}"><xsl:value-of select="entry-value/value/@filename" /></a></span>
                        <input type="hidden" value="untouched" name="{@name}-info" id="{@name}-info" />
                    </xsl:when>
                    <xsl:otherwise>
                        <span><i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/></span>
                    </xsl:otherwise>
                </xsl:choose>
	        </label>
        </div>
        <script type="text/javascript">
            <xsl:if test="entry-value/value">
                $j('#field-<xsl:value-of select="$inputId"/>').find('.close').fadeIn()
            </xsl:if>
            
            function changeFile_<xsl:value-of select="$fnSuffixId"/>($event, id) 
            {
                var emptyText = "<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>";
                
                var input = $event;
                var url = $j($event).val()
                var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
                var parts = url.split("\\");
                var fileName = parts[parts.length - 1];
                $j('#field-' + id).find('label span').html(fileName);

                if(fileName == '') {
                    $j($event).val('');
                    $j('#field-' + id).find('label span').html(emptyText);
                    $j('#field-' + id).find('.close').fadeOut();
                    $j('#field-' + id).find('input[value="untouched"]').val(''); // reset untouched input
                } else {
                    $j('#field-' + id).find('.close').fadeIn();
                }
            }
            
            function removeFile_<xsl:value-of select="$fnSuffixId"/>(e) {
                var emptyText = "<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>";
                const parent = $j(e).parent();
                $j(parent).find('input').val('');
                $j(parent).find('label').children('span').html(emptyText);
                $j(parent).find('.close').fadeOut();
            }
        </script>
    </xsl:template>
    
</xsl:stylesheet>