<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:exslt="http://exslt.org/common"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            exclude-result-prefixes="sitemap resolver ametys i18n exslt">

    
    <xsl:import href="skin://stylesheets/search.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
	<xsl:import href="plugin:link-directory://pages/services/directory/utils/thumbnails_utils.xsl"/>

    <xsl:template name="header">
    	<header>
			
            <div class="container">
                
                <xsl:call-template name="header-left"/>
                
                <xsl:call-template name="header-icons"/>
                
            </div>
            
			<xsl:call-template name="menu-mobile"/>
        </header>
    </xsl:template>
    
    <xsl:template name="header-left">
        <div class="left">
            <!-- Logo -->
            <xsl:call-template name="header-main-logo"/>
            
            <xsl:call-template name="search"/>
            
            <xsl:call-template name="main-menu">
                <xsl:with-param name="device">desktop</xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="header-icons">
        <div class="icons">
            <ul>
                <xsl:call-template name="search-button"/>
                
                <xsl:call-template name="top-links"/>
                <xsl:call-template name="alerts"/>
                
                <!-- User menu -->
                <xsl:call-template name="user-menu"/>
                
                <li class="burger"> <a href="#" onclick="openMenuMobile()"><i class="fas fa-bars"></i></a>
                </li>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template name="top-links">
        <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='topMenu']/links/link" mode="thumbnails">
             <xsl:with-param name="showThemes">false</xsl:with-param>
             <xsl:with-param name="showUrl">false</xsl:with-param>
             <xsl:with-param name="showTitle">false</xsl:with-param>
             <xsl:with-param name="width">22</xsl:with-param>
             <xsl:with-param name="height">22</xsl:with-param>
             <xsl:with-param name="uniqueId" select="concat('header_link_', $uniqueId)"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="alerts">
        <li class="link">
            <xsl:variable name="allalertes" select="ametys:findPagesIdsByTag('ALL_FLASH_INFO')"/>
            
            <a href="{resolver:resolve('page', $allalertes/@id)}">
                <xsl:call-template name="alerts-icon"/>
                <span class="link-dynamic-info">
                    <xsl:if test="count(/cms/inputData/Model/alerts/content) &gt; 0">
                        <span class="link-info-short-value"></span>
                        <div class="dropdown message">
                            <div class="space"></div>
                            <ul>
                                <li>
                                    <a href="{resolver:resolve('page', $allalertes/@id)}">
                                       <i18n:text i18n:key="SKIN_ALERTS" i18n:catalogue="skin.{$skin}"/> (<xsl:value-of select="count(/cms/inputData/Model/alerts/content)"/>)
                                    </a>
                                </li>
                                
                                <xsl:for-each select="/cms/inputData/Model/alerts/content">
                                    <li>
                                        <a href="{resolver:resolve('page', $allalertes/@id)}">
                                            <span class="link-info-title"><xsl:value-of select="@title"/></span>
                                            <span class="message">
                                                <xsl:copy-of select="html/body//p[@class='content-abstract']"/>
                                            </span>
                                        </a>
                                    </li>
                                </xsl:for-each>
                            </ul>
                        </div>
                    </xsl:if>
                </span>
                
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="alerts-icon">
        <i class="fas fa-bell"></i>
    </xsl:template>
    
    <xsl:template name="body-background-image">
    	<xsl:variable name="banner" select="ametys:templateParameter('image')"/>   
    	
	    <xsl:if test="$banner">     
            <xsl:variable name="bannerUrl" select="resolver:resolveImage($banner/@type, $banner/@path, '', 1920)"/>
	        <xsl:attribute name="style">background-image : url(<xsl:value-of select="ametys:escapeURLforCSS($bannerUrl)"/>);</xsl:attribute>
        </xsl:if>  
    </xsl:template>
    
    <xsl:template name="header-main-logo">
        <div class="logo">
            <a href="{$site-uri-prefix}/{$lang}/index.html" class="logo-color">
                <img src="{ametys:skinURL('templates/common/img/logo-colorful.png')}" alt="Ametys" />
            </a>
            <a href="{$site-uri-prefix}/{$lang}/index.html" class="logo-white">
                <img src="{ametys:skinURL('templates/common/img/logo-white.png')}" alt="Ametys" />
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="user-menu">
    	<xsl:if test="$currentUser/user/login">
	    	<li class="profil" style="display: none">
	            <a href="#">
	            	<xsl:call-template name="profil-img"/>
	            </a>
		    	<div class="dropdown profil-dropdown">
		            <div class="space"></div>
		            <ul>
		                <li>
		                	<xsl:choose>
		                        <xsl:when test="$currentUser/user/pageId != ''">
		                            <a href="{resolver:resolve('page', $currentUser/user/pageId)}" class="ametys-header-invoker__text_profile">Afficher le profil</a>
		                        </xsl:when>
		                        <xsl:otherwise>
		                            <span class="ametys-header-invoker__text_profile">&#160;</span>
		                        </xsl:otherwise>
		                    </xsl:choose>
		                </li>
		                <!-- Logout -->
		                <xsl:call-template name="user-menu-logout"/>
		            </ul>
		        </div>
		    </li>
		</xsl:if>
		
		<script type="text/javascript">
            $j(document).ready(function() {
                var _getAmetysUserCb = function(user)
                {
                    if (user)
                    {
                        $j('.profil').show();
                    }
                    else
                    {
                        $j('.profil').hide();
                    }
                }
                
                getAmetysUser(_getAmetysUserCb);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="user-menu-logout">
        <li>
            <a href="{ametys:siteUriPrefix()}/logout.html?requestedURL={ametys:siteUriPrefix()}/{$lang}/index.html" >
                <span><i18n:text i18n:key="SKIN_LOGOUT" i18n:catalogue="skin.{$skin}"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-activities">
         <div class="ametys-header-q-panel">
            <a class="ametys-header-invoker" href="javascript:;" id="qPanel">
                <span class="ametys-header-invoker__icon icon-activity_icon"></span>
                <span class="ametys-indicator ametys-indicator--bordered ametys-indicator--danger"></span>
            </a>
        </div>
    </xsl:template>
    
</xsl:stylesheet>