<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
					
	<xsl:import href="plugin:link-directory://pages/services/directory/utils/inputdata_utils.xsl"/>
	<xsl:import href="skin://services/link-directory/pages/services/directory/utils/config_utils.xsl"/>
	
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
	<xsl:variable name="sectionInPath" select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false') and (@sitemap:in-path='true')]" />
							
    <xsl:template name="main-menu">
    	<xsl:param name="device"/>
    	
    	<xsl:if test="$device != 'desktop'">
    		<xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
		    	<xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
		    		<div class="return return-{position()}" onclick="closeLevel{position()}()"><i class="fas fa-arrow-left"></i></div>
		    	</xsl:if>
		    </xsl:for-each>
	    </xsl:if>
            
    	<ul class="links">
    		<xsl:if test="$device = 'desktop'">
    			<xsl:attribute name="class">links desktop</xsl:attribute>
    		</xsl:if>
    		
    		<!-- For each page with SECTION tag : page[@PLUGIN_TAGS_SECTION] -->
    		<xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
	            <li>
	            	<xsl:attribute name="class">
	            		<xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">has-submenu </xsl:if>
		            	<xsl:if test="@sitemap:in-path='true'"> active</xsl:if>
		            </xsl:attribute>
	                <a>
	                	<xsl:attribute name="href">
	                		<xsl:choose>
	                			<xsl:when test="$device != 'desktop' and page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">#</xsl:when>
	                			<xsl:otherwise><xsl:value-of select="resolver:resolve('page', @sitemap:id)"/></xsl:otherwise>
	                		</xsl:choose>
	                	</xsl:attribute>
                        <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                            <xsl:call-template name="external-link-attributes"/>
                        </xsl:if>
	                	<xsl:value-of select="@sitemap:title" />
	            	</a>
	            	<xsl:call-template name="submenu">
	            		<xsl:with-param name="device" select="$device"/>
	            	</xsl:call-template>
	            </li>
	        </xsl:for-each>
        </ul>
        <xsl:call-template name="main-menu-script">
	        <xsl:with-param name="device" select="$device"/>
	    </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="submenu">
    	<xsl:param name="device"/>
    	
        <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
            <div class="submenu">
                <xsl:if test="$device != 'desktop'">
                    <xsl:attribute name="class">submenu submenu-1</xsl:attribute>
                </xsl:if>
                <div class="levels">
                    <!-- Level 1 -->
                    <xsl:call-template name="submenu-level1">
                        <xsl:with-param name="device" select="$device"/>
                    </xsl:call-template>
                    
                    <!-- Level 2 -->
                    <xsl:call-template name="submenu-level2">
	            		<xsl:with-param name="device" select="$device"/>
	            	</xsl:call-template>
                    
                    <!-- Level 3 -->
                    <xsl:call-template name="submenu-level3">
	            		<xsl:with-param name="device" select="$device"/>
	            	</xsl:call-template>
                  </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    
    <!-- Level 2 -->
    <xsl:template name="submenu-level1">
        <xsl:param name="device"/>
        
        <div class="level level-1">
            <ul>
                <li class="title">
                    <a href="{resolver:resolve('page', @sitemap:id)}">
                        <xsl:value-of select="@sitemap:title" />
                    </a>
                </li>
                
                <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-1"/>
            </ul>
        </div>
    </xsl:template>
    
    <!-- Level 2 -->
    <xsl:template name="submenu-level2">
        <xsl:param name="device"/>
        
        <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']/page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
            <div class="level level-2">
                <xsl:if test="$device != 'desktop'">
                    <xsl:attribute name="class">submenu submenu-2 level level-2</xsl:attribute>
                </xsl:if>
                
                <xsl:for-each select="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                    <ul data-level-3="{generate-id()}">
                        <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-2"/>
                    </ul>
                </xsl:for-each>
             </div>
        </xsl:if>
    </xsl:template>
    
    <!-- Level 3 -->
    <xsl:template name="submenu-level3">
        <xsl:param name="device"/>
        
        <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']/page[not(@sitemap:invisible) or @sitemap:invisible = 'false']/page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
            <div class="level level-3">
                <xsl:if test="$device != 'desktop'">
                    <xsl:attribute name="class">submenu submenu-3 level level-3</xsl:attribute>
                </xsl:if>
                
                <xsl:for-each select="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]/page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                    <ul data-level-4="{generate-id()}">
                        <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-3"/>
                    </ul>
                </xsl:for-each>
             </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="level-1">
        <li>
			<xsl:attribute name="class"><xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">has-level-3</xsl:if><xsl:if test="@sitemap:in-path='true'"> active</xsl:if></xsl:attribute>
			<xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
				<xsl:attribute name="data-level-3"><xsl:value-of select="generate-id()"/></xsl:attribute>
    		</xsl:if>
    		<a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes"/>
                </xsl:if>
            	<span><xsl:value-of select="@sitemap:title" /></span>
        	</a>
    	</li>
    </xsl:template>
    
    <xsl:template match="page" mode="level-2">
        <li>
            <xsl:attribute name="class"><xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">has-level-4</xsl:if><xsl:if test="@sitemap:in-path='true'"> active</xsl:if></xsl:attribute>
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <xsl:attribute name="data-level-4"><xsl:value-of select="generate-id()"/></xsl:attribute>
            </xsl:if>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes"/>
                </xsl:if>
                <span><xsl:value-of select="@sitemap:title" /></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="level-3">
        <li>
    		<xsl:attribute name="class"><xsl:if test="@sitemap:in-path='true'"> active</xsl:if></xsl:attribute>
    		<a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes"/>
                </xsl:if>
            	<span><xsl:value-of select="@sitemap:title" /></span>
        	</a>
    	</li>
    </xsl:template>
    
    <xsl:template name="main-menu-script">
    	<xsl:param name="device"/>
    	
    	<script>
			<xsl:if test="$device = 'desktop'">
	            // DESKTOP 
	            $j(".desktop .level-1 li a").hover(function () {
	                $j(".level-1 li a").removeClass('hover');
	                $j(".level-1 li a").parent().removeClass('hover');
	                $j('.level-2 ul').hide();
	                $j('.level-2').removeClass('has-one-open');
	                const level3 = $j(this).parent().data('level-3');
	
	                $j('.level-3 ul').hide();
                    $j(".level-2 li a").removeClass('hover');
                    $j(".level-2 li a").parent().removeClass('hover');

	                if (level3 !== undefined) {
	                    $j(this).addClass('hover');
	                    $j(this).parent().addClass('hover');
	                    
	                    $j('.level-2').addClass('has-one-open');
	
	                    $j(`[data-level-3='${level3}']`).show();
	                } else {
	                    $j('.level-2 ul').hide();
	                    $j('.level-2').removeClass('has-one-open');
                    }
                });

                $j(".desktop .level-2 li a").hover(function () {
                    $j(".level-2 li a").removeClass('hover');
                    $j(".level-2 li a").parent().removeClass('hover');
                    $j('.level-3 ul').hide();

                    const level4 = $j(this).parent().data('level-4');

                    if (level4 !== undefined) {
                        $j(this).addClass('hover');
                        $j(this).parent().addClass('hover');
                        $j(`[data-level-4='${level4}']`).show();
                    } else {
                        $j('.level-3 ul').hide();
	                    
	                    }
	                });
			    

                // MOBILE

			    // DESKTOP 
	            $j(document).scroll(function () {
	                const scroll = $j(window).scrollTop();
	
	                if (scroll == 0) {
	                    $j('header').removeClass('sticky');
	                } else {
	                    $j('header').addClass('sticky');
	
	                }
	            });
			</xsl:if>
	    </script>
    </xsl:template>
    
    <xsl:template name="menu-mobile">
        <div class="menu-mobile">
            <div class="close" onclick="closeMenuMobile()" aria-hidden="true"><i class="fas fa-times"></i></div>
            <xsl:call-template name="menu-mobile-logo"/>
            <xsl:call-template name="main-menu"/>
            <div class="access-mobile"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="menu-mobile-logo">
        <a href="{$site-uri-prefix}/{$lang}/index.html">
             <img class="logo" src="{ametys:skinURL('templates/common/img/logo.png')}" alt="Logo Ametys" />
        </a>
    </xsl:template>
    
    <xsl:template name="right-menu">
    	<div class="nav-perso">
            
            <xsl:call-template name="right-menu-additional-buttons"/>
            
    		<div class="close"><i class="fas fa-times" onclick="closeNavPerso()" aria-hidden="true"></i></div>
    		<xsl:call-template name="user-right-menu"/>
    		
            <xsl:call-template name="right-menu-custom-top"/>
            
    		<xsl:call-template name="favoris">
    		    <xsl:with-param name="inputDataId" select="'applications'"/>
                <xsl:with-param name="themeId" select="'MES_APPLICATIONS'"/>
                <xsl:with-param name="title"><i18n:text i18n:key="SKIN_MENU_APPLICATIONS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="class">favourites</xsl:with-param>
    		</xsl:call-template>
            
            <xsl:call-template name="right-menu-custom-middle"/>
    		
    		<xsl:call-template name="favoris">
                <xsl:with-param name="inputDataId" select="'favoris'"/>
                <xsl:with-param name="themeId" select="'MES_FAVORIS'"/>
                <xsl:with-param name="title"><i18n:text i18n:key="SKIN_MENU_FAVORIS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="class">favourites-inline</xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="right-menu-custom-bottom"/>
            
            <script>
               var openedMenu = 0;
               
                function openNavPerso() {
                    $j('.nav-perso').addClass('open');
                    $j('.espace-perso-btn-in-menu').addClass('open');
                    $j('.overlayNav').addClass('active');
                 
                    if (openedMenu == 0) {
                        setTimeout(function () {
                            
                            <xsl:call-template name="favoris-open-menu-js">
                                <xsl:with-param name="inputDataId" select="'applications'"/>
                            </xsl:call-template>
                            
                            <xsl:call-template name="favoris-open-menu-js">
                                <xsl:with-param name="inputDataId" select="'favoris'"/>
                            </xsl:call-template>
                            
                        }, 200);
                    }
                    openedMenu++;
                
                }
             </script>
             
             <xsl:call-template name="right-menu-additional-script"/>
    		
            <xsl:call-template name="right-menu-zone"/>
    	</div>
    </xsl:template>
    
    <xsl:template name="right-menu-additional-script"/>
    
    <xsl:template name="right-menu-zone">
        <div class="zone-right">
            <zone name="right"/>
        </div>
    </xsl:template>
    
    <xsl:template name="right-menu-additional-buttons"/>
    <xsl:template name="right-menu-custom-top"/>
    <xsl:template name="right-menu-custom-middle"/>
    <xsl:template name="right-menu-custom-bottom"/>
    
    <xsl:template name="favoris-open-menu-js">
        <xsl:param name="inputDataId"/>
        
        var $tool = $j('#tool-ametys_<xsl:value-of select="$inputDataId"/>');
	        $tool.HSAmetysTools($j('#tool-ametys_<xsl:value-of select="$inputDataId"/>').data('settings'));
	
	        $tool.on('elementDeactivated', deactivateLink_ametys_<xsl:value-of select="$inputDataId"/>);
	        $tool.on('elementActivated', activateLink_ametys_<xsl:value-of select="$inputDataId"/>);
	        $tool.on('elementMoved', moveLink_ametys_<xsl:value-of select="$inputDataId"/>);
	        $tool.on('elementDeleted', deleteLink_ametys_<xsl:value-of select="$inputDataId"/>);
    
    </xsl:template>
    
    <xsl:template name="favoris">
        <xsl:param name="themeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="title"/>
        <xsl:param name="class"/>
        
        <xsl:if test="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[themes/theme/@id = $themeId]">
    
            <xsl:call-template name="configure-links-internal">
                <xsl:with-param name="links" select="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[themes/theme/@id = $themeId]"/>
                <xsl:with-param name="configurable" select="/cms/inputData/linkDirectory[@id=$inputDataId]/@configurable"/>
                <xsl:with-param name="display-user-links" select="/cms/inputData/linkDirectory[@id=$inputDataId]/@displayUserLinks"/>
                <xsl:with-param name="savingId" select="$inputDataId"/>
                <xsl:with-param name="uniqueId" select="$inputDataId"/>
                <xsl:with-param name="title" select="$title"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="userLinksThemeId" select="$themeId"/>
            </xsl:call-template>

            
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-right-menu">
    	<div class="profil">
            <div class="picture">
            	<xsl:call-template name="profil-img"/>
            </div>
            <div class="info">
                <span class="name"><xsl:value-of select="$currentUser/user/firstname"/></span>
                
                <xsl:call-template name="user-right-menu-links"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="user-right-menu-links">
        <xsl:if test="/cms/inputData/linkDirectory[@id='topMenu']/links/link">
            <ul>
                <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='topMenu']/links/link" mode="thumbnails">
                     <xsl:with-param name="showThemes">false</xsl:with-param>
                     <xsl:with-param name="showUrl">false</xsl:with-param>
                     <xsl:with-param name="showTitle">false</xsl:with-param>
                     <xsl:with-param name="width">22</xsl:with-param>
                     <xsl:with-param name="height">22</xsl:with-param>
                     <xsl:with-param name="uniqueId" select="concat('profile_link_', $uniqueId)"/>
                </xsl:apply-templates>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="profil-img">
        <xsl:choose>
            <xsl:when test="$currentUser/user/imgUrl">
                <img class="open-dropdown" src="{$currentUser/user/imgUrl}"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="{ametys:skinURL('templates/common/img/avatar.png')}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="navinterieur">
        <xsl:if test="$sectionInPath">
            <div class="ametys-cms-service ametys-secondary-menu" data-content="">
            
                <!-- Section title -->
                <xsl:call-template name="navinterieur-title"/>
                
                <section class="first">
                    <xsl:apply-templates select="$sectionInPath/page" mode="navinterieur"/>
                </section>
                
            </div>
            
            <xsl:call-template name="navinterieur-js"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="navinterieur-title">
        <h2 class="service-title open">
            <xsl:value-of select="$sectionInPath/@sitemap:title" />
        </h2>
    </xsl:template>
    
    <!-- Menu nav intérieur -->
    <xsl:template match="page" mode="navinterieur">
        <xsl:param name="level">2</xsl:param>
        
        <xsl:variable name="hasChildren" select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']"/>        
        <div>
            <xsl:attribute name="class">
                <xsl:if test="$hasChildren">has-submenu</xsl:if>
                <xsl:if test="@sitemap:in-path='true' and not($hasChildren)"> open current-section</xsl:if>
            </xsl:attribute>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:current='true'">
                    <xsl:attribute name="class">current</xsl:attribute>
                </xsl:if>
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes"/>
                </xsl:if>
                <xsl:value-of select="@sitemap:title" />
                
                <xsl:if test="$hasChildren">
                    <xsl:call-template name="nav-interieur-icon"/>
                </xsl:if>
            </a>
        </div>
        
        <xsl:if test="$hasChildren">
            <section>
                <xsl:attribute name="class">
                    <xsl:text>level-</xsl:text><xsl:value-of select="$level"/>
                    <xsl:if test="@sitemap:in-path='true' and not(page)"> current-section</xsl:if>
                </xsl:attribute>
                <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="navinterieur">
                    <xsl:with-param name="level" select="$level+1"/>
                </xsl:apply-templates>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="nav-interieur-icon">
       <div class="chevron">
         <svg width="11.2535094px" height="7.26635041px" viewBox="0 0 11.2535094 7.26635041" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <title>chevron</title>
            <g id="Produit" stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd">
                <g id="Produit-interieur-colonne-droite"
                    transform="translate(-1468.748232, -594.617059)" fill="#1ABC9C"
                    fill-rule="nonzero">
                    <g id="menu-secondaire"
                        transform="translate(1011.000000, 306.000000)">
                        <g id="chevron" transform="translate(457.748232, 288.617059)">
                            <path d="M6.22440952,0.247425266 C5.89392783,-0.083056429 5.35958157,-0.083056429 5.02909987,0.25092715 L0.247861271,5.03216575 C-0.0826204237,5.35911123 -0.0826204237,5.89349182 0.247861271,6.22397352 L1.04591311,7.01848914 C1.37285859,7.34897083 1.90723918,7.34897083 2.23768654,7.01848914 L5.6267547,3.62945532 L9.01932473,7.01498726 C9.34627021,7.34543462 9.8806508,7.34543462 10.2111325,7.01498726 L11.0056481,6.2204373 C11.3361298,5.89349182 11.3361298,5.35911123 11.0056481,5.02866387 L6.22440952,0.247425266 Z" id="Path"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
       </div>
    </xsl:template>
    
    <xsl:template name="navinterieur-js">
        <script>
            $j(function () {
              const current = $j(".ametys-secondary-menu .current");
              if (current.length > 0) {
                const $section = current.parent().parent();

                if ($section.hasClass("first")) {
                  let previousSubmenu = current.closest(".has-submenu");
                  previousSubmenu.addClass("open");
                  previousSubmenu.next("section").show();
                } else {
                  const levelClass = $section.attr("class");
                  const [level, number] = levelClass.split("-");
                  let previousSubmenu;
                  previousSubmenu = $section.prev();
                  previousSubmenu.addClass("open");
                  previousSubmenu.next("section").show();

                  for (let i = number; i > 1; i--) {
                    previousSubmenu = previousSubmenu.parent().prev();
                    previousSubmenu.addClass("open");
                    previousSubmenu.next("section").show();
                  }
                }
                getLastSection();
              }
            });
            
            $j(".ametys-secondary-menu .has-submenu .chevron").click(function (e) {
                e.preventDefault();
                
                var $parent = $j(this).closest(".has-submenu");
                if ($parent.hasClass("open")) {
                    // close
                    $parent.removeClass("open");
                    $parent.next("section").hide();
                } else {
                    // Open
                    $parent.addClass("open");
                    $parent.next("section").show();
                }
                 
                
                // scroll to the click
                $j("html, body").animate(
                   {
                      scrollTop: $j(this).offset().top - 200,
                    },
                   500
                );
            });

            <!-- $j(".ametys-secondary-menu .has-submenu .chevron").click(function (e) {
              e.preventDefault();

              var $parent = $j(this).closest(".has-submenu");

              if ($parent.hasClass("open")) {
                $parent.removeClass("open");
                $parent.next("section").hide();
                $parent.children("section").hide();
              } else {
                $parent.parent().find("section").hide();
                $parent.parent().find("div").removeClass("open");

                $parent.addClass("open");
                $parent.next("section").show();
              }
              getLastSection();
              // scroll to the click
              $j("html, body").animate(
                {
                  scrollTop: $j(this).offset().top - 200,
                },
                500
              );
            });-->

            function getLastSection() {
              const $lastSubmenu = $j(
                ".ametys-secondary-menu .has-submenu.open"
              ).last();
              const $lastVisibleSection = $lastSubmenu.next("section:visible");
              $j(".current-section").removeClass("current-section");
              $lastVisibleSection.addClass("current-section");
              $lastSubmenu.addClass("current-section");
            }
          </script>
    </xsl:template>
    
</xsl:stylesheet>