<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="ametys docbook"
                              extension-element-prefixes="text resolver user">

	<xsl:import href="skin://stylesheets/content/member/member-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl" />
    
	<xsl:variable name="common-content-css-class-name">item annuary-item</xsl:variable>
	
	<xsl:template name="common-content-body">
        <xsl:call-template name="common-content-body-content"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id" select="user:getUserPage(@id)"/>
        
        <a href="{resolver:resolve('page', $page-id, false)}" class="ametys-cms-content view-abstract mobility wrapper">
            <xsl:call-template name="user-link-attribute"/>
	        <xsl:call-template name="user-image"/>
	        <div class="arrivant">
	            <xsl:call-template name="user-name"/>
	            <xsl:call-template name="user-function"/>
	        </div>
         </a>
    </xsl:template>
    
    <xsl:template name="user-link-attribute">
        <xsl:if test="metadata/firstname or metadata/lastname">
            <xsl:attribute name="title"><xsl:value-of select="metadata/firstname"/><xsl:text> </xsl:text><xsl:value-of select="metadata/lastname"/></xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-name">
        <xsl:if test="metadata/firstname or metadata/lastname">
            <span class="firstname"><xsl:value-of select="metadata/firstname"/><xsl:text> </xsl:text><xsl:value-of select="metadata/lastname"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-image">
	    <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <img alt="{metadata/illustration/alt-text}" src="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@path, 81, 81)}" />
            </xsl:when>
	        <xsl:when test="metadata/user">
                <xsl:call-template name="user-profile-image">
                    <xsl:with-param name="size">81</xsl:with-param>
                    <xsl:with-param name="login" select="metadata/user/@login"/>
                    <xsl:with-param name="population" select="metadata/user/@populationId"/>
                    <xsl:with-param name="lang" select="@language"/>
                </xsl:call-template>
	        </xsl:when>
	        <xsl:otherwise>
	            <xsl:call-template name="user-default-image"/>
	        </xsl:otherwise>
	    </xsl:choose>
    </xsl:template>

</xsl:stylesheet>